% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{slice}
\alias{slice}
\alias{slice.ir}
\alias{slice_sample.ir}
\title{Subset rows in \code{ir} objects using their positions}
\source{
\code{\link[dplyr:slice]{dplyr::slice()}}
}
\usage{
slice.ir(.data, ..., .preserve = FALSE)

slice_sample.ir(.data, ..., n, prop, weight_by = NULL, replace = FALSE)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{For \code{slice()}: <\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Integer row
values.

Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.
Indices beyond the number of rows in the input are silently ignored.

For \code{slice_helpers()}, these arguments are passed on to methods.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used.

If a negative value of \code{n} or \code{prop} is provided, the specified number or
proportion of rows will be removed.

If \code{n} is greater than the number of rows in the group (or \code{prop > 1}),
the result will be silently truncated to the group size. If the
\code{prop}ortion of a group size does not yield an integer number of rows, the
absolute value of \code{prop*nrow(.data)} is rounded down.}

\item{weight_by}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input. Weights are
automatically standardised to sum to 1.}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without
(\code{FALSE}, the default) replacement.}
}
\value{
\code{.data} with subsetted rows.
}
\description{
Subset rows in \code{ir} objects using their positions
}
\examples{
## slice
dplyr::slice(ir_sample_data, 1:5)
dplyr::slice_min(ir_sample_data, holocellulose, n = 3)
dplyr::slice_max(ir_sample_data, holocellulose, n = 3)
dplyr::slice_head(ir_sample_data, n = 5)
dplyr::slice_tail(ir_sample_data, n = 5)

## slice_sample
set.seed(234)
dplyr::slice_sample(ir_sample_data, n = 3)


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
