% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_variance_region.R
\name{ir_variance_region}
\alias{ir_variance_region}
\title{Computes the variance of a spectrum in an \code{ir} object in a given region}
\usage{
ir_variance_region(
  x,
  subtract_smoothed = FALSE,
  do_normalize = FALSE,
  normalize_method,
  ...,
  range = NULL
)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}. These are the spectra for
which to compute the variance.}

\item{subtract_smoothed}{A logical value. If \code{subtract_smoothed = TRUE},
\code{x} is copied, the copy smoothed using \code{ir_smooth} with
\code{method = "sg"} and subtracted from \code{x} before the variance of the
intensity values from \code{x} is computed. This allows e.g. to estimate the
noise level in a specific region of spectra. If
\code{subtract_smoothed = FALSE} (the default), nothing is subtracted from
\code{x} before computing the variance of the intensity values.}

\item{do_normalize}{A logical value. If set to \code{TRUE}, the spectra in
\code{x} are normalized after subtraction of a smoothed version, else no
normalization is performed.}

\item{normalize_method}{See \code{\link[=ir_normalize]{ir_normalize()}}.}

\item{...}{Arguments passed to \code{\link[=ir_smooth]{ir_smooth()}} (except for
\code{method} which is always set to \code{"sg"} if \code{subtract_smoothed} is
\code{TRUE}). If \code{subtract_smoothed = FALSE}, these arguments will be
ignored.}

\item{range}{See \code{\link[=ir_clip]{ir_clip()}}. This is the range for which the
variance of the intensity values will be computed.}
}
\value{
\code{x} with two additional columns:
\describe{
\item{variance}{A numeric vector with the computed variances of the
intensity values for the respective spectra.}
\item{n_variance}{An integer vector with the number of intensity values
used during computing the variance.}
}
}
\description{
\code{ir_variance_region} takes a spectrum \code{x} and, depending on the
arguments computes the following summary:
\describe{
\item{if \code{subtract_smoothed = FALSE}}{it computes the variance of the
intensity values for each spectrum in \code{x}. If in addition \code{range}
is not \code{NULL}, it computes the variance only for the region(s)
represented by \code{range}.}
\item{if \code{subtract_smoothed = TRUE}}{it smoothes \code{x}, subtracts
the smoothed \code{x} from the unsmoothed \code{x} and computes the
variance of the difference intensity values. If in addition \code{range} is
not \code{NULL}, it computes the variance only for the region(s)
represented by \code{range}.}
}
}
\examples{
# Whole spectra variance
x1 <-
   ir::ir_sample_data \%>\%
   ir::ir_variance_region(
      subtract_smoothed = FALSE,
      do_normalize = TRUE,
      normalize_method = "area",
      range = NULL
   )

# Spectra variance, but only from a specific region
range <- data.frame(start = 2700, end = 2800)

x2 <-
   ir::ir_sample_data \%>\%
   ir::ir_normalize(method = "area") \%>\%
   ir::ir_variance_region(
      subtract_smoothed = FALSE,
      do_normalize = TRUE,
      normalize_method = "area",
      range = range
   )

# Spectra variance after subtracting a smoothed version of the spectra and
# only from a specific region
x3 <-
   ir::ir_sample_data \%>\%
   ir::ir_variance_region(
      subtract_smoothed = TRUE,
      do_normalize = FALSE,
      range = range,
      p = 3, n = 31, ts = 1, m = 0
   )

}
