% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIModels.R
\name{get_Model}
\alias{get_Model}
\title{construct a given regression model thanks to a training set}
\usage{
get_Model(X = NULL, Y = NULL, model_name = "elasticnet", params = NA)
}
\arguments{
\item{X}{is a matrix of features (e.g. fingerprints and/or physical descriptors) issued from a training set.}

\item{Y}{is a one-dimensional vector, or a matrix, of observables (e.g. targeted chemical properties) issued from a training
set.}

\item{model_name}{is the model's name to be built ("elasticnet" by default).}

\item{params}{is a list of fixed parameters applied to the model (see \code{\link{get_Model_params}} for a detailed view of the
default paramaters per model). For the "svm" model, a.k.a Support Vector Machine, Gaussian RBF or Laplace kernel
("rbfdot" or "laplacedot" respectively) are supported (limitation from the \code{\link[kernlab]{sigest}} function used as optimizer on the sigma parameter).}
}
\value{
the desired regression model optimized.
}
\description{
Construct a given regression model thanks to a training set.
}
\examples{
\dontrun{elasticNet_model <- get_Model(X = X[training,], Y = Y[training,],
model = "elasticnet", params = list("alpha" = 0.5))}
}
