% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_score.R
\name{get_score}
\alias{get_score}
\title{get QSPR scores for structures in the SmcChem object}
\usage{
get_score(smchem)
}
\arguments{
\item{smchem}{SmcChem object}
}
\description{
get QSPR scores for structures in the SmcChem object
}
\examples{
data(engram_5k) 
data(qsprpred_EG_5k)
smchem <- SmcChem$new(smis = rep("c1ccccc1O", 25), v_qsprpred=qsprpred_EG_5k,
                     v_engram=engram_5k,temp=3)
scores <- matrix(0, 25, 5)
for(i in 1:5){
smchem$smcexec(1)
scores[,i] <- get_score(smchem)
boxplot(scores)
}

}

