% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{save_extract_as_json}
\alias{save_extract_as_json}
\alias{define_extract_from_json}
\title{Store an extract definition in JSON format}
\usage{
save_extract_as_json(extract, file, overwrite = FALSE)

define_extract_from_json(extract_json)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{file}{File path to which to write the JSON-formatted extract
definition.}

\item{overwrite}{If \code{TRUE}, overwrite \code{file} if it already exists.
Defaults to \code{FALSE}.}

\item{extract_json}{Path to a file containing a JSON-formatted
extract definition.}
}
\value{
An \code{\link[=ipums_extract-class]{ipums_extract}} object.
}
\description{
Read and write an \code{\link[=ipums_extract-class]{ipums_extract}} object to a JSON
file that contains the extract definition specifications.

Use these functions to store a copy of an extract definition outside of your
R environment and/or share an extract definition with another registered
IPUMS user.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\section{API Version Compatibility}{

As of v0.6.0, ipumsr only supports IPUMS API version 2. If you have stored
an extract definition made using version beta or version 1 of the IPUMS
API, you will not be able to load it using \code{define_extract_from_json()}. The
API version for the request should be stored in the saved JSON file. (If
there is no \code{"api_version"} or \code{"version"} field in the JSON file, the
request was likely made under version beta or version 1.)

If the extract definition was originally made under your user account and
you know its corresponding extract number, use \code{\link[=get_extract_info]{get_extract_info()}} to obtain
a definition compliant with IPUMS API version 2. You can then save this
definition to JSON with \code{save_extract_as_json()}.

Otherwise, you will need to update the JSON file to be compliant with
IPUMS API version 2. In general, this should only require renaming
all JSON fields written in \code{snake_case} to \code{camelCase}. For instance,
\code{"data_tables"} would become \code{"dataTables"}, \code{"data_format"} would become
\code{"dataFormat"}, and so on. You will also need to change the \code{"api_version"}
field to \code{"version"} and set it equal to \code{2}. If you are unable to create
a valid extract by modifying the file, you may have to recreate the
definition manually using the appropriate
\code{\link[=define_extract]{define_extract_*()}} function.

See the IPUMS developer documentation for more details on
\href{https://developer.ipums.org/docs/apiprogram/versioning/}{API versioning} and
\href{https://developer.ipums.org/docs/apiprogram/changelog/}{breaking changes}
introduced in version 2.
}

\examples{
my_extract <- define_extract_usa(
  description = "2013-2014 ACS Data",
  samples = c("us2013a", "us2014a"),
  variables = c("SEX", "AGE", "YEAR")
)

extract_json_path <- file.path(tempdir(), "usa_extract.json")
save_extract_as_json(my_extract, file = extract_json_path)

copy_of_my_extract <- define_extract_from_json(extract_json_path)

identical(my_extract, copy_of_my_extract)

file.remove(extract_json_path)
}
\seealso{
\code{\link[=define_extract]{define_extract_*()}} to define an extract request manually.

\code{\link[=get_extract_info]{get_extract_info()}} to obtain a past extract to save.

\code{\link[=submit_extract]{submit_extract()}} to submit an extract request for processing.

\code{\link[=add_to_extract]{add_to_extract()}} and \code{\link[=remove_from_extract]{remove_from_extract()}} to
revise an extract definition.
}
