% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewer.R
\name{ipums_view}
\alias{ipums_view}
\title{View a static webpage with variable information from a IPUMS extract}
\usage{
ipums_view(x, out_file = NULL, launch = TRUE)
}
\arguments{
\item{x}{An \link{ipums_ddi} object or a data frame with IPUMS attributes
attached.

Note that the file-level information (e.g. extract notes) are only
available when providing an \code{ipums_ddi} object.}

\item{out_file}{Optional location to save produced HTML file. If \code{NULL},
makes a temporary file.}

\item{launch}{Logical indicating whether to launch the website.}
}
\value{
The filepath to the html (silently if \code{launch = TRUE})
}
\description{
Requires that htmltools, shiny and DT are installed.
}
\examples{
ddi <- read_ipums_ddi(ipums_example("cps_00157.xml"))
\dontrun{
ipums_view(ddi)
ipums_view(ddi, "codebook.html", launch = FALSE)
}
}
