% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-terra_read.R
\name{read_terra_micro}
\alias{read_terra_micro}
\title{Read data from an IPUMS Terra microdata extract}
\usage{
read_terra_micro(
  data_file,
  ddi_file = NULL,
  data_layer = NULL,
  n_max = Inf,
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)
}
\arguments{
\item{data_file}{Path to the data file, which can either be the .zip file directly
downloaded from the IPUMS Terra website, a path to the unzipped version of that
folder, or to the csv unzipped from the download.}

\item{ddi_file}{(Optional) If the download is unzipped, path to the .xml file which
provides usage and citation information for extract.}

\item{data_layer}{For .zip extracts with multiple datasets, the name of the
data to load. Accepts a character vector specifying the file name, or a
\link[=selection_language]{tidyselect selection}. Data layer must uniquely
identify a dataset.}

\item{n_max}{Maximum number of observations to read from the data}

\item{verbose}{Logical, indicating whether to print progress information
to console.}

\item{var_attrs}{Variable attributes to add from the DDI, defaults to
adding all (val_labels, var_label and var_desc). See
\code{\link{set_ipums_var_attributes}} for more details.}
}
\value{
\code{read_terra_micro} returns a \code{tbl_df} with the tabular data. Use
\code{\link{read_ipums_sf}} or \code{\link{read_ipums_sp}} to read shape
data out of a microdata Terra extract.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Reads a microdata dataset downloaded from the IPUMS Terra extract system.

Support for IPUMS Terra has been discontinued. This function will be
removed in a future release. For general handling of raster data in R, see the
\link[terra:terra-package]{terra} package.
}
\examples{
\dontrun{
data <- read_terra_micro("2553_bundle.zip")
}
}
\keyword{internal}
