% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_url.R
\name{ipums_website}
\alias{ipums_website}
\title{Launch a browser window to an IPUMS metadata page}
\usage{
ipums_website(
  x,
  var,
  project = NULL,
  launch = TRUE,
  verbose = TRUE,
  var_label = NULL,
  homepage_if_missing = TRUE
)
}
\arguments{
\item{x}{An \code{\link{ipums_ddi}} object. If left empty, \code{project} must be specified.}

\item{var}{Name of the variable to load}

\item{project}{Name of an IPUMS project. Must be one of:
\code{"IPUMS-USA"}, \code{"IPUMS-CPS"}, \code{"IPUMS-International"}, \code{"IPUMS-DHS"},
\code{"ATUS-X"}, \code{"AHTUS-X"}, \code{"MTUS-X"}, \code{"NHIS"}, \code{"Higher Ed"}, \code{"NHGIS"}}

\item{launch}{If \code{TRUE}, launch the website.}

\item{verbose}{If \code{TRUE}, produces message if no variable-specific websites
are found.}

\item{var_label}{Variable label for the provided \code{var}.

This may be useful if the URL produced by \code{var} alone is incorrect.

Only used if specifying \code{project}, not \code{x}.}

\item{homepage_if_missing}{If \code{TRUE}, return the project homepage if the
project does not provide variable-specific web pages.}
}
\value{
The URL to the IPUMS webpage for the indicated project and variable
(silently if launch is \code{TRUE})
}
\description{
Using an \link{ipums_ddi} object or IPUMS project
along with a variable name, guesses the most appropriate URL for
the variable's page on the IPUMS website.

Currently, this is only available for Windows operating systems.
}
\details{
Note that some IPUMS projects (e.g. NHGIS) do not have variable-specific
pages.

The generated URL may not work for variables that are constructed during the
extract creation process.
}
\examples{
ddi <- read_ipums_ddi(ipums_example("cps_00157.xml"))

\dontrun{
# Launch webpage for particular variable
ipums_website(ddi, "MONTH")
}

# Can specify an IPUMS project instead of using an `ipums_ddi` object
ipums_website(var = "RECTYPE", project = "IPUMS-CPS", launch = FALSE)
}
