% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.r
\name{lbl_define}
\alias{lbl_define}
\title{Define labels for an unlabelled vector}
\usage{
lbl_define(x, ...)
}
\arguments{
\item{x}{An unlabelled atomic vector}

\item{...}{Two-sided formulas where the left hand side is a label placeholder
(created with the \code{\link{lbl}} function) and the right hand side is a
function that returns a logical vector that indicates which existing values
should be assigned that labeled value. The right hand side is passed to a
function similar to \code{\link[rlang]{as_function}}, so also accepts
quosure-style lambda functions (that use values .val and .lbl). See
examples for more information.}
}
\value{
A haven::labelled vector
}
\description{
Creates a \code{\link[haven]{labelled}} vector from an unlabelled atomic
vector using \code{\link{lbl_relabel}} syntax, which allows grouping multiple
values into a single labelled value. Values not assigned a label will remain
unlabelled.
}
\examples{
age <- c(10, 12, 16, 18, 20, 22, 25, 27)

# Note that values not assigned a new labelled value remain unchanged
lbl_define(
  age,
  lbl(1, "Pre-college age") ~ .val < 18,
  lbl(2, "College age") ~ .val >= 18 & .val <= 22
)
}
\seealso{
Other lbl_helpers: 
\code{\link{lbl_add}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_collapse}()},
\code{\link{lbl_na_if}()},
\code{\link{lbl_relabel}()},
\code{\link{lbl}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
