% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipums_info.r
\name{ipums_var_info}
\alias{ipums_var_info}
\alias{ipums_var_desc}
\alias{ipums_var_label}
\alias{ipums_val_labels}
\title{Get IPUMS variable information}
\usage{
ipums_var_info(object, vars = NULL)

ipums_var_desc(object, var = NULL)

ipums_var_label(object, var = NULL)

ipums_val_labels(object, var = NULL)
}
\arguments{
\item{object}{A DDI object (loaded with \code{\link{read_ipums_ddi}}), a data.frame
with ipums metadata attached, or a single column from an ipums data.frame.}

\item{vars}{dplyr \code{\link[dplyr]{select}}-style notation for the variables to
give information about}

\item{var}{select-style notation for a single variable

\code{ipums_var_info()} loads all available variable information for one or more
variables into a data.frame. If \code{object} is a vector, it will include
the variable label, variable description and value labels. If \code{object} is
a data.frame, it will include it for all variables (or only those specified
by vars). If it is a DDI, it will also include information used to read the
data from disk, including start/end position in the fixed-width file, implied
decimals and variable type.

\code{ipums_var_desc()} loads the variable description for a single variable.

\code{ipums_var_label()} loads the short variable label for a single variable.

\code{ipums_val_labels()} loads the value labels for a single variable.

Note that many R functions drop attributes that provide this information.
In order to make sure that they are available, it is best to keep a copy of the
separate from the data your are manipulating using \code{\link{read_ipums_ddi}}. Then
you can refer to the IPUMS documentation in this object.}
}
\value{
\code{ipums_var_info} returns a \code{tbl_df} data frame with variable information, and
  the other functions return a length 1 character vector.
}
\description{
Get IPUMS metadata information about variables loaded into R. Will try to read
the metadata from the loaded datasets, but it is more reliable to load the DDI
into a separate object and use it instead.
}
\examples{
ddi <- read_ipums_ddi(ipums_example("cps_00006.xml"))

ipums_var_info(ddi)
ipums_var_desc(ddi, MONTH)
ipums_var_label(ddi, MONTH)
ipums_val_labels(ddi, MONTH)

}
