% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_ranges.R
\name{country_ranges}
\alias{country_ranges}
\title{Return CIDR ranges for given ISO 3166-1 alpha-2 country codes}
\usage{
country_ranges(countries)
}
\arguments{
\item{countries}{character vector of ISO 3166-1 alpha-2 country codes (case-insensitive)}
}
\value{
named list of character vectors of CIDR blocks
}
\description{
Query \url{https://www.iwik.org/ipcountry/} for the CIDR ranges for a given
set of ISO 3166-1 alpha-2 country codes and return the results in a named
list of character vectors.
}
\details{
An internal cache of the CIDR query results are maintained as they only change
daily (12:00 CET). The cache can be flushed with \code{flush_country_cidrs} and
which codes have been cached can be retrieved with \code{cached_country_cidrs)}.
}
\note{
This function requires internet connectivity as it pulls daily updated data
      from \url{https://www.iwik.org/ipcountry/}.
}
\examples{
rng <- country_ranges(c("PW", "UZ"))
}
