% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clt_illustrates.R
\name{see_the_wlln_for_uniform}
\alias{see_the_wlln_for_uniform}
\title{Illustration of the weak law of large numbers  for sampling from the 
uniform distribution}
\usage{
see_the_wlln_for_uniform(nsize = 10, nrep = 1000)
}
\arguments{
\item{nsize}{Sample size, n. Its default value is 10.}

\item{nrep}{Number of replications. How many samples of size \code{nsize} 
should be taken, default value is 10000.}
}
\value{
A list giving the x values and the density estimates y, from the 
generated random samples.  The function  also draws the empirical density on
the  current graphics device.
}
\description{
Illustration of the weak law of large numbers  for sampling from the 
uniform distribution
}
\examples{
a1 <- see_the_wlln_for_uniform(nsize=1, nrep=50000)
a2 <- see_the_wlln_for_uniform(nsize=10, nrep=50000)
a3 <- see_the_wlln_for_uniform(nsize=50, nrep=50000)
a4 <- see_the_wlln_for_uniform(nsize=100, nrep=50000)
plot(a4, type="l", lwd=2, ylim=range(c(a1$y, a2$y, a3$y, a4$y)), col=1, 
lty=1, xlab="mean", ylab="density estimates")
lines(a3, type="l", lwd=2, col=2, lty=2)
lines(a2, type="l", lwd=2, col=3, lty=3)
lines(a1, type="l", lwd=2, col=4, lty=4)
symb <- c("n=1", "n=10", "n=50", "n=100")
legend(x=0.37, y=11.5, legend = symb, lty =4:1, col = 4:1)
}
