% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ipm.R
\name{make_ipm}
\alias{make_ipm}
\alias{make_ipm.simple_di_det}
\alias{make_ipm.simple_di_stoch_kern}
\alias{make_ipm.simple_di_stoch_param}
\alias{make_ipm.general_di_det}
\alias{make_ipm.general_di_stoch_kern}
\alias{make_ipm.general_di_stoch_param}
\alias{make_ipm.simple_dd_det}
\alias{make_ipm.simple_dd_stoch_kern}
\alias{make_ipm.simple_dd_stoch_param}
\alias{make_ipm.general_dd_det}
\alias{make_ipm.general_dd_stoch_kern}
\alias{make_ipm.general_dd_stoch_param}
\title{Methods to implement an IPM}
\usage{
make_ipm(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...
)

\method{make_ipm}{simple_di_det}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  normalize_pop_size = TRUE,
  iteration_direction = "right"
)

\method{make_ipm}{simple_di_stoch_kern}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NULL,
  normalize_pop_size = TRUE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{simple_di_stoch_param}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NULL,
  normalize_pop_size = TRUE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{general_di_det}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  normalize_pop_size = TRUE,
  iteration_direction = "right"
)

\method{make_ipm}{general_di_stoch_kern}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NULL,
  normalize_pop_size = TRUE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{general_di_stoch_param}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NULL,
  normalize_pop_size = TRUE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{simple_dd_det}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  normalize_pop_size = FALSE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{simple_dd_stoch_kern}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NA_character_,
  normalize_pop_size = FALSE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{simple_dd_stoch_param}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NA_character_,
  normalize_pop_size = FALSE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{general_dd_det}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  normalize_pop_size = FALSE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{general_dd_stoch_kern}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NA_character_,
  normalize_pop_size = FALSE,
  report_progress = FALSE,
  iteration_direction = "right"
)

\method{make_ipm}{general_dd_stoch_param}(
  proto_ipm,
  return_main_env = TRUE,
  return_all_envs = FALSE,
  usr_funs = list(),
  ...,
  domain_list = NULL,
  iterate = TRUE,
  iterations = 50,
  kernel_seq = NA_character_,
  normalize_pop_size = FALSE,
  report_progress = FALSE,
  iteration_direction = "right"
)
}
\arguments{
\item{proto_ipm}{A proto_ipm. This should be the
output of \code{define_kernel}, or the \code{define_*} functions.}

\item{return_main_env}{A logical indicating whether to return the main environment
for the model. This environment contains the integration mesh, weights, and
other potentially useful variables for subsequent analyses. Default is
\code{TRUE}.}

\item{return_all_envs}{A logical indicating whether to return the environments that
the kernel expressions are evaluated in. These may be useful for some analyses,
such as regression-level sensitivity/elasticity analyses, but can also rapidly
increase memory consumption for models with many kernels (e.g. ones with hierarchical
effects that have many levels, or any \code{*_stoch_param} model). Default is
\code{FALSE}.}

\item{usr_funs}{An optional list of user-specified functions that are passed
on to the  model building process. This can help make vital rate expressions
more concise and expressive. Names in this list should exactly match the names
of the function calls in the \code{...} or \code{formula}.}

\item{...}{Other arguments passed to methods.}

\item{domain_list}{An optional list of new domain information to implement
the IPM with.}

\item{iterate}{A logical indicating whether or not iterate the model before exiting
or just return the sub-kernels. Only applies to density-independent, deterministic
models and density-independent, stochastic kernel re-sampled models.}

\item{iterations}{If \code{iterate} is \code{TRUE}, then the number of iterations
to run the model for.}

\item{normalize_pop_size}{A logical indicating whether to re-scale the population
vector to sum to 1 before each iteration. Default is \code{TRUE} for
\code{*_di_*} methods and \code{FALSE} for \code{*_dd_*} methods.}

\item{iteration_direction}{Either \code{"right"} (default) or \code{"left"}.
This controls the direction of projection. Right iteration will generate
the right eigenvector (if it exists), while left iteration generates
the left eigenvector. These correspond to the stable trait distributions, and
reproductive values, respectively. This parameter is mostly used internally
by other functions. Use with care.}

\item{kernel_seq}{For \code{*_stoch_kern} methods, the sequence of kernels
to use during the simulation process. It should have the same number of entries
as the number of \code{iterations}.
This should be a vector containing levels of the hierarchical effects specified
in \code{levels_hier_effs}, or empty. Support for Markov chains will eventually
get implemented. If it is empty, \code{make_ipm} will try to generate a
sequence internally using a random selection of the \code{levels_hier_effs}
defined in \code{define_kernel}.}

\item{report_progress}{A logical indicating whether or not to periodically
report progress for a stochastic simulation. Does not apply to deterministic
methods. Default is \code{FALSE}.}
}
\value{
The \code{make_ipm.*} methods will always return a list of length 6
containing the following components:

\itemize{
  \item{\strong{sub_kernels}}{: a list of arrays specified in \code{define_kernel}.}
  \item{\strong{env_list}}{: a list containing the evaluation environments of
                           kernel. This will contain the \code{main_env} object
                           if \code{return_main_env = TRUE}. It will also contain
                           the sub-kernels evaluation environments if
                           \code{return_all_envs = TRUE}. }
  \item{\strong{env_seq}}{: a character vector with length \code{iterations} of
                             kernel indices indicating the order
                             in which kernels are to be/were resampled OR
                             a matrix with as many columns as stochastic parameters
                             and \code{n_iterations} rows.}
  \item{\strong{pop_state}}{: population vectors
                             stored as a list of arrays. The first dimension
                             of each array corresponds to the state variable distribution,
                             and the second dimension corresponds to time
                             steps.}
  \item{\strong{proto_ipm}}{: the \code{proto_ipm} object used to implement
                             the model.}
}

In addition to the list class, each object will have a class comprised of the
arguments from  \code{init_ipm} plus \code{'ipm'} pasted together with
underscores. This is to facilitate \code{print}, \code{plot}, and
\code{lambda} methods. For example, a \code{init_ipm("general", "di", "det")}
model will have the class \code{'general_di_det_ipm'} once it has been
implemented using \code{make_ipm}.
}
\description{
The \code{make_ipm.*} methods convert a \code{proto_ipm} into a
set of discretized kernels and population vectors. Methods have different
requirements, so be sure to read the parameter documentation. \code{
vignette('ipmr-introduction', 'ipmr')}  a more complete introduction.
}
