% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-export.R
\name{collapse_pop_state}
\alias{collapse_pop_state}
\title{Extract threshold based population size information}
\usage{
collapse_pop_state(ipm, time_step, ...)
}
\arguments{
\item{ipm}{An object created by \code{make_ipm}}

\item{time_step}{the time step to pull out. Can be a single time step or a
vector of multiple time steps. In the latter case, one value is computed for
each time step.}

\item{...}{Named expressions that provide the threshold information for the
desired classes. The expression should be logicals with a state variable name
on the left side, and a threshold value on the right side.}
}
\value{
A named list of numeric vectors containing the summed population
sizes at each requested time step. Names are taken from \code{...}.
}
\description{
Given a model object, this function computes population sizes
given thresholds for a state variable of interest. For example,
the number (or proportion) of individuals shorter than 60 cm tall at the 20th
time step of the model.
}
\examples{
data(gen_di_det_ex)

# Rebuild the model and return_main_env this time

gen_di_det_ex <- gen_di_det_ex$proto_ipm \%>\%
  make_ipm(iterate = TRUE, iterations = 50, return_main_env = TRUE)

disc_sizes <- collapse_pop_state(gen_di_det_ex,
                                 time_step = 20:25,
                                 seedlings = ht <= 10,
                                 NRA = ht > 10 & ht <= 200,
                                 RA = ht > 200)

# time series for this model. This extracts the first 20 iterations
# (excluding the initial population state) and collapses them according
# to the rules we pass to ...


 time_series <- collapse_pop_state(gen_di_det_ex,
                                   time_step = 2:21,
                                   seedlings = ht <= 10,
                                   NRA = ht > 10 & ht <= 200,
                                   RA = ht > 200)

}
