/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PlotPrimitive;
import org.rosuda.ibase.toolkit.PlotTextVector;
import org.rosuda.ibase.toolkit.QueryPopup;
import org.rosuda.ibase.toolkit.WinTracker;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Global;
import org.rosuda.util.Stopwatch;
import org.rosuda.util.Tools;

public class BaseCanvas
extends PGSCanvas
implements Dependent,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    public Color COL_OUTLINE = Color.BLACK;
    public Color COL_INVALID = Color.RED;
    public Color COL_SELBG = new Color(Common.selectColor.getRed(), Common.selectColor.getGreen(), Common.selectColor.getBlue(), 76);
    public Color COL_ZOOMBG = new Color(0.0f, 0.3f, 1.0f, 0.25f);
    protected static final String C_BLACK = "black";
    static final String C_MARKED = "marked";
    static final String C_ASELBG = "aSelBg";
    static final String C_ADRAGBG = "aDragBg";
    static final String C_OBJECT = "object";
    static final String M_PRINT = "print";
    static final String M_EXPORTCASES = "exportCases";
    static final String M_ROTATE = "rotate";
    static final String M_SONLYSELECTED = "showOnlySelected";
    static final String M_SEPERATEALPHAS = "seperateAlphas";
    static final String M_HALPHADOWN = "halphaDown";
    static final String M_HALPHAUP = "halphaUp";
    protected static final String M_RESETZOOM = "resetZoom";
    protected static final String M_TRANSHIGHL = "transparentHighlighting";
    protected static final String M_ALPHADOWN = "alphaDown";
    protected static final String M_ALPHAUP = "alphaUp";
    protected static final String M_SETCB1 = "setCB1";
    protected static final String M_SETCB64 = "setCB64";
    static final String M_RESETCB = "resetCB";
    static final String M_SETCBBYSEL = "setCBbyselection";
    public Color fillColor = null;
    public Color borderColor = null;
    public Color fillColorSel = null;
    public Color borderColorSel = null;
    protected QueryPopup qi;
    protected PlotPrimitive[] pp;
    protected List queryables = new ArrayList();
    protected boolean dontCache = false;
    protected SMarker m;
    public boolean autoAdjustMargins = true;
    protected int mLeft;
    protected int mRight;
    protected int mTop;
    protected int mBottom;
    protected int orientation = 0;
    protected boolean resizeOnRotate = true;
    protected boolean allow180 = false;
    protected boolean allowZoom = true;
    protected boolean allowDragZoom = true;
    protected boolean zoomRetainsAspect = true;
    protected boolean allowDragMove = false;
    private boolean showLabels = true;
    protected boolean baseDrag;
    protected boolean selDrag;
    protected boolean zoomDrag;
    protected boolean moveDrag;
    protected boolean inQuery = false;
    protected boolean inZoom = false;
    protected boolean showOnlyHilited = false;
    protected boolean ignoreNotifications = false;
    protected List zoomSequence;
    protected int W;
    protected int H;
    protected int baseDragX1;
    protected int baseDragX2;
    protected int baseDragY1;
    protected int baseDragY2;
    protected boolean paintOutline = true;
    protected boolean selectedPaintOutline = true;
    protected boolean fillInside = true;
    protected boolean dontPaint = true;
    protected boolean updateGeometry = false;
    protected boolean objectClipping = false;
    protected boolean alphaHighlighting = false;
    protected boolean seperateAlphas = false;
    protected float ppAlpha = 1.0f;
    protected float ppAlphaH = 1.0f;
    protected Axis[] opAx;
    protected Axis[] opAy;
    protected PlotTextVector xLabels;
    protected PlotTextVector yLabels;
    protected boolean isExtQuery = false;
    private boolean useExtQuery = false;
    private String extQueryString = "";
    MenuItem MIsonlyselected = null;
    MenuItem MIseperatealphas = null;
    MenuItem MIhalphaup = null;
    MenuItem MIhalphadown = null;
    protected MenuItem MItransHighl = null;
    protected PopupMenu pop = new PopupMenu();
    protected int mouseX;
    protected int mouseY;
    protected PlotPrimitive lastQueriedPrimitive = null;
    protected int lastQueriedIndex;
    private boolean useObjectTranparency = true;
    protected int defaultMLeft;
    protected int defaultMRight;
    protected int defaultMTop;
    protected int defaultMBottom;
    protected int defaultMLeft1;
    protected int defaultMRight1;
    protected int defaultMTop1;
    protected int defaultMBottom1;
    protected int defaultMLeft2;
    protected int defaultMRight2;
    protected int defaultMTop2;
    protected int defaultMBottom2;
    protected int defaultMLeft3;
    protected int defaultMRight3;
    protected int defaultMTop3;
    protected int defaultMBottom3;
    public int horizontalMedDist = 50;
    public int horizontalMinDist = 35;
    public int verticalMedDist = 50;
    private int maxMLeft = 60;
    public int verticalMinDist = 35;
    public boolean rotateYLabels = true;
    public double rotateYLabelsBy = 90.0;
    protected int changingHilitingNeedsUpdateRoot = 1;
    protected boolean showQuery = false;

    public BaseCanvas(int n, Frame frame, SMarker sMarker) {
        super(n, 4);
        Global.forceAntiAliasing = true;
        this.m = sMarker;
        this.setFrame(frame);
        this.ay = null;
        this.ax = null;
        this.zoomSequence = new ArrayList();
        this.mBottom = 0;
        this.mTop = 0;
        this.mRight = 0;
        this.mLeft = 0;
        this.setBackground(Common.backgroundColor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        frame.addKeyListener(this);
        this.qi = this.newQueryPopup(frame, sMarker == null ? null : sMarker.getMasterSet(), "BaseCanvas");
        this.xLabels = new PlotTextVector(this.getPlotManager(), 0, 0);
        this.yLabels = new PlotTextVector(this.getPlotManager(), 0, 0);
        this.xLabels.setLayer(0);
        this.yLabels.setLayer(0);
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        if (this.ignoreNotifications) {
            if (Global.DEBUG > 0) {
                System.out.println("Warning, BaseCanvas received notification (" + notifyMsg + "), with ignoreNotifications set. Ignoring event.");
            }
            return;
        }
        if ((notifyMsg.getMessageID() & 0xFFF000) == 12288 || notifyMsg.getMessageID() == 8194) {
            this.updateObjects();
        }
        this.setUpdateRoot(notifyMsg.getMessageID() == 4096 ? this.changingHilitingNeedsUpdateRoot : 0);
        this.repaint();
    }

    public void updateObjects() {
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.mLeft + this.mRight + 20, this.mTop + this.mBottom + 20);
    }

    public Axis getAxisX() {
        return this.ax;
    }

    public Axis getAxisY() {
        return this.ay;
    }

    public void paintPoGraSS(PoGraSS poGraSS) {
        int n;
        boolean bl;
        boolean bl2;
        if (this.dontPaint) {
            return;
        }
        if (this.autoAdjustMargins) {
            this.adjustMargin(poGraSS);
        }
        Rectangle rectangle = this.getBounds();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        if (Global.DEBUG > 0) {
            System.out.println("BaseCanvas.paint: real bounds [" + n2 + ":" + n3 + "], existing [" + this.W + ":" + this.H + "], orientation=" + this.orientation + " mTop=" + this.mTop + ",mBottom=" + this.mBottom);
        }
        boolean bl3 = false;
        boolean bl4 = (this.orientation & 1) == 0 ? this.H != n3 : (bl2 = this.W != n2);
        boolean bl5 = (this.orientation & 1) == 0 ? this.W != n2 : (bl = this.H != n3);
        do {
            if (this.ay != null && (bl2 || this.updateGeometry)) {
                this.setAyDefaultGeometry();
            }
            if (this.opAy != null && (bl2 || this.updateGeometry)) {
                switch (this.orientation) {
                    case 0: {
                        for (n = 0; n < this.opAy.length; ++n) {
                            if (this.opAy[n] == null) continue;
                            this.opAy[n].setGeometry(1, n3 - this.mBottom, this.mTop + this.mBottom - n3);
                        }
                        break;
                    }
                    case 1: {
                        for (n = 0; n < this.opAy.length; ++n) {
                            if (this.opAy[n] == null) continue;
                            this.opAy[n].setGeometry(0, this.mLeft, n2 - this.mLeft - this.mRight);
                        }
                        break;
                    }
                    case 2: {
                        for (n = 0; n < this.opAy.length; ++n) {
                            if (this.opAy[n] == null) continue;
                            this.opAy[n].setGeometry(1, this.mTop, n3 - this.mTop - this.mBottom);
                        }
                        break;
                    }
                    case 3: {
                        for (n = 0; n < this.opAy.length; ++n) {
                            if (this.opAy[n] == null) continue;
                            this.opAy[n].setGeometry(0, n2 - this.mRight, this.mLeft + this.mRight - n2);
                        }
                        break;
                    }
                }
            }
            if (this.ax != null && (bl || this.updateGeometry)) {
                this.setAxDefaultGeometry();
            }
            if (this.opAx != null && (bl || this.updateGeometry)) {
                switch (this.orientation) {
                    case 0: {
                        for (n = 0; n < this.opAx.length; ++n) {
                            if (this.opAx[n] == null) continue;
                            this.opAx[n].setGeometry(0, this.mLeft, n2 - this.mLeft - this.mRight);
                        }
                        break;
                    }
                    case 1: {
                        for (n = 0; n < this.opAx.length; ++n) {
                            if (this.opAx[n] == null) continue;
                            this.opAx[n].setGeometry(1, this.mTop, n3 - this.mTop - this.mBottom);
                        }
                        break;
                    }
                    case 2: {
                        for (n = 0; n < this.opAx.length; ++n) {
                            if (this.opAx[n] == null) continue;
                            this.opAx[n].setGeometry(0, n2 - this.mRight, this.mLeft + this.mRight - n2);
                        }
                        break;
                    }
                    case 3: {
                        for (n = 0; n < this.opAx.length; ++n) {
                            if (this.opAx[n] == null) continue;
                            this.opAx[n].setGeometry(1, n3 - this.mBottom, this.mTop + this.mBottom - n3);
                        }
                        break;
                    }
                }
            }
            bl3 = this.autoAdjustMargins && this.adjustMargin(poGraSS);
            boolean bl6 = this.updateGeometry = this.updateGeometry || bl3;
        } while (bl3);
        if (this.H != n3 || this.W != n2 || this.updateGeometry) {
            this.W = n2;
            this.H = n3;
            this.updateObjects();
        }
        this.updateGeometry = false;
        if (Global.DEBUG > 0) {
            System.out.println("BaseCanvas.paint: [w=" + n2 + "/h=" + n3 + "] ax=" + this.ax + " ay=" + this.ay);
        }
        poGraSS.setBounds(n2, n3);
        poGraSS.begin();
        this.paintInit(poGraSS);
        if (this.dontCache || poGraSS.localLayerCache < 0 || poGraSS.localLayerCache == 0) {
            this.paintBack(poGraSS);
        }
        if ((this.dontCache || poGraSS.localLayerCache < 0 || poGraSS.localLayerCache == 0) && !this.showOnlyHilited) {
            this.paintObjects(poGraSS);
        }
        this.nextLayer(poGraSS);
        if (this.dontCache || poGraSS.localLayerCache < 0 || poGraSS.localLayerCache == 1) {
            this.paintSelected(poGraSS);
        }
        this.nextLayer(poGraSS);
        if (!(!this.baseDrag || this.allowDragMove && this.moveDrag || !this.dontCache && poGraSS.localLayerCache >= 0 && poGraSS.localLayerCache != 2)) {
            int n4;
            n = this.baseDragX1;
            int n5 = this.baseDragX2;
            int n6 = this.baseDragY1;
            int n7 = this.baseDragY2;
            if (n > n5) {
                n4 = n;
                n = n5;
                n5 = n4;
            }
            if (n6 > n7) {
                n4 = n6;
                n6 = n7;
                n7 = n4;
            }
            poGraSS.setColor(this.selDrag ? this.COL_SELBG : this.COL_ZOOMBG);
            poGraSS.fillRect(n, n6, n5 - n, n7 - n6);
            poGraSS.setColor(this.COL_OUTLINE);
            poGraSS.drawRect(n, n6, n5 - n, n7 - n6);
        }
        this.nextLayer(poGraSS);
        if (this.dontCache || poGraSS.localLayerCache < 0 || poGraSS.localLayerCache == 3) {
            this.paintPost(poGraSS);
        }
        poGraSS.end();
    }

    public void paintInit(PoGraSS poGraSS) {
    }

    public void paintBack(PoGraSS poGraSS) {
    }

    public void paintObjects(PoGraSS poGraSS) {
        boolean bl = false;
        Stopwatch stopwatch = new Stopwatch();
        if (this.objectClipping) {
            poGraSS.setClip(this.mLeft, this.mTop, this.getBounds().width - this.mLeft - this.mRight, this.getBounds().height - this.mTop - this.mBottom);
        }
        if (this.pp != null) {
            poGraSS.setColor(C_OBJECT);
            for (int i = 0; i < this.pp.length; ++i) {
                if (this.pp[i] == null || !this.pp[i].isVisible()) continue;
                if (this.pp[i].isPerformingAlphaBlending()) {
                    if (!bl) {
                        poGraSS.setGlobalAlpha(this.ppAlpha);
                        bl = true;
                    }
                } else if (bl) {
                    poGraSS.resetGlobalAlpha();
                    bl = false;
                }
                this.pp[i].paint(poGraSS, this.orientation, this.m);
            }
            if (bl) {
                poGraSS.resetGlobalAlpha();
            }
        }
        if (this.objectClipping) {
            poGraSS.resetClip();
        }
        stopwatch.profile("BaseCanvas.paintObjects");
    }

    public void paintSelected(PoGraSS poGraSS) {
        boolean bl = this.alphaHighlighting;
        Stopwatch stopwatch = new Stopwatch();
        if (this.objectClipping) {
            poGraSS.setClip(this.mLeft, this.mTop, this.getBounds().width - this.mLeft - this.mRight, this.getBounds().height - this.mTop - this.mBottom);
        }
        if (this.pp != null) {
            if (this.alphaHighlighting) {
                poGraSS.setGlobalAlpha(this.seperateAlphas ? this.ppAlphaH : this.ppAlpha);
            }
            poGraSS.setColor(C_MARKED);
            for (int i = 0; i < this.pp.length; ++i) {
                if (this.pp[i] == null || !this.pp[i].isVisible()) continue;
                if (this.pp[i].isPerformingAlphaBlending()) {
                    if (this.alphaHighlighting) {
                        if (!bl) {
                            poGraSS.setGlobalAlpha(this.ppAlpha);
                            bl = true;
                        }
                    } else if (bl) {
                        poGraSS.resetGlobalAlpha();
                        bl = false;
                    }
                }
                this.pp[i].paintSelected(poGraSS, this.orientation, this.m);
            }
            if (this.alphaHighlighting) {
                poGraSS.resetGlobalAlpha();
            }
        }
        if (this.objectClipping) {
            poGraSS.resetClip();
        }
        stopwatch.profile("BaseCanvas.paintSelected");
    }

    public void paintPost(PoGraSS poGraSS) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getButton();
        if (n3 == 3) {
            if (this.pop != null) {
                this.pop.show(this.getFrame(), n, n2 + 40);
            }
            return;
        }
        if (this.baseDragX1 == n && this.baseDragY1 == n2) {
            Point point = this.getFrame().getLocation();
            Point point2 = this.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            if (Global.DEBUG > 0) {
                String string = "";
                if (mouseEvent.isShiftDown()) {
                    string = string + " SHIFT";
                }
                if (mouseEvent.isAltDown()) {
                    string = string + " ALT";
                }
                if (mouseEvent.isControlDown()) {
                    string = string + " CTRL";
                }
                if (mouseEvent.isMetaDown()) {
                    string = string + " META";
                }
                if (mouseEvent.isAltGraphDown()) {
                    string = string + " ALT.GR";
                }
                if ((mouseEvent.getModifiers() & 0x10) == 16) {
                    string = string + " M1";
                }
                if ((mouseEvent.getModifiers() & 8) == 8) {
                    string = string + " M2";
                }
                if ((mouseEvent.getModifiers() & 4) == 4) {
                    string = string + " M3";
                }
                if (mouseEvent.isPopupTrigger()) {
                    string = string + " POPUP";
                }
                System.out.println("Event:" + mouseEvent + string);
            }
            if (Common.isZoomTrigger(mouseEvent)) {
                this.performZoomOut(n, n2);
                return;
            }
            boolean bl = Common.isSelectTrigger(mouseEvent);
            boolean bl2 = Common.isQueryTrigger(mouseEvent);
            if (Global.DEBUG > 0) {
                System.out.println("select=" + bl + ", query=" + bl2 + ", isMac=" + Common.isMac());
            }
            boolean bl3 = false;
            boolean bl4 = true;
            if (bl2 || bl) {
                boolean bl5 = false;
                int n4 = Common.getSelectMode(mouseEvent);
                if (n4 > 1) {
                    bl5 = true;
                }
                if (this.pp != null) {
                    if (bl2) {
                        PlotPrimitive plotPrimitive = this.getFirstPrimitiveContaining(n, n2);
                        if (plotPrimitive != null && plotPrimitive.isQueryable() && plotPrimitive != null) {
                            if (plotPrimitive.cases() > 0) {
                                if (plotPrimitive.getPrimaryCase() != -1) {
                                    this.setQueryText(this.queryObject(plotPrimitive), plotPrimitive.getPrimaryCase());
                                } else {
                                    this.setQueryText(this.queryObject(plotPrimitive), plotPrimitive.getCaseIDs());
                                }
                            } else {
                                this.setQueryText(this.queryObject(plotPrimitive));
                            }
                            if (this.showQuery) {
                                this.qi.setLocation(point.x + n, point.y + n2);
                                this.qi.show();
                                bl4 = false;
                            }
                        }
                    } else {
                        PlotPrimitive[] plotPrimitiveArray = this.getPrimitivesContaining(n, n2);
                        if (n4 == 0) {
                            this.m.selectNone();
                            bl3 = true;
                        }
                        for (int i = 0; i < plotPrimitiveArray.length; ++i) {
                            if (plotPrimitiveArray[i] == null) continue;
                            bl3 = true;
                            plotPrimitiveArray[i].setMark(this.m, bl5);
                        }
                        if (!bl3) {
                            this.m.selectNone();
                        }
                    }
                }
            }
            if (!bl3 && bl && this.m.getList().size() > 0) {
                this.m.selectNone();
                bl3 = true;
            }
            if (bl3) {
                this.m.NotifyAll(new NotifyMsg(this.m, 4096));
            }
            if (bl4) {
                this.qi.hide();
            }
        }
    }

    public String queryObject(int n) {
        if (this.pp != null && this.pp[n] != null) {
            return this.queryObject(this.pp[n]);
        }
        return "object ID " + n;
    }

    public String queryObject(PlotPrimitive plotPrimitive) {
        if (this.lastQueriedPrimitive != null && this.lastQueriedPrimitive == plotPrimitive) {
            return this.queryObject(this.lastQueriedIndex);
        }
        for (int i = 0; i < this.pp.length; ++i) {
            if (this.pp[i] != plotPrimitive) continue;
            return this.queryObject(i);
        }
        return "object " + plotPrimitive.toString();
    }

    public String queryPlotSpace() {
        return null;
    }

    public void rotate(int n) {
        this.orientation = this.orientation + n & 3;
        if (!this.allow180) {
            this.orientation &= 1;
        }
        switch (this.orientation) {
            case 0: {
                this.mLeft = this.defaultMLeft;
                this.mRight = this.defaultMRight;
                this.mTop = this.defaultMTop;
                this.mBottom = this.defaultMBottom;
                break;
            }
            case 1: {
                this.mLeft = this.defaultMLeft1;
                this.mRight = this.defaultMRight1;
                this.mTop = this.defaultMTop1;
                this.mBottom = this.defaultMBottom1;
                break;
            }
            case 2: {
                this.mLeft = this.defaultMLeft2;
                this.mRight = this.defaultMRight2;
                this.mTop = this.defaultMTop2;
                this.mBottom = this.defaultMBottom2;
                break;
            }
            case 3: {
                this.mLeft = this.defaultMLeft3;
                this.mRight = this.defaultMRight3;
                this.mTop = this.defaultMTop3;
                this.mBottom = this.defaultMBottom3;
            }
        }
        this.setUpdateRoot(0);
        this.updateGeometry = true;
        if (this.resizeOnRotate && (n == 1 || n == 3)) {
            Frame frame = this.getFrame();
            Dimension dimension = frame.getSize();
            frame.setSize(dimension.height, dimension.width);
        } else {
            this.repaint();
        }
    }

    public void rotate() {
        this.rotate(1);
    }

    public void performZoomIn(int n, int n2, int n3, int n4) {
        this.performZoomIn(n, n2, n3, n4, this.ax, this.ay);
    }

    public void performZoomIn(int n, int n2, int n3, int n4, Axis axis, Axis axis2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (Global.DEBUG > 0) {
            System.out.println("performZoomIn(" + n + "," + n2 + "," + n3 + "," + n4 + ") [zoomSequence.len=" + this.zoomSequence.size() + "]");
        }
        boolean bl = this.ignoreNotifications;
        this.ignoreNotifications = true;
        double d5 = 1.0;
        double d6 = 1.0;
        if (axis != null && axis.getType() == 0) {
            d4 = 1.0;
            d3 = 1.0;
            d3 = axis.getValueForPos(n);
            d4 = axis.getValueForPos(n3);
            if ((d4 - d3) * axis.vLen < 0.0) {
                d2 = d4;
                d4 = d3;
                d3 = d2;
            }
            d5 = n == n3 ? axis.vLen / 2.0 : d4 - d3;
            d6 = (d3 + d4) / 2.0;
        }
        d4 = 1.0;
        d3 = 1.0;
        if (axis2 != null && axis2.getType() == 0) {
            d2 = 1.0;
            d = 1.0;
            d2 = axis2.getValueForPos(n2);
            d = axis2.getValueForPos(n4);
            if ((d - d2) * axis2.vLen < 0.0) {
                double d7 = d;
                d = d2;
                d2 = d7;
            }
            d4 = n2 == n4 ? axis2.vLen / 2.0 : d - d2;
            d3 = (d2 + d) / 2.0;
        }
        if (axis != null && axis2 != null && this.zoomRetainsAspect) {
            d2 = axis.vLen / axis2.vLen;
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if ((d = d5 / d4) < 0.0) {
                d = -d;
            }
            if (d > d2) {
                d4 *= d / d2;
            } else {
                d5 *= d / d2;
            }
        }
        if (axis != null && axis2.getType() == 0) {
            this.zoomSequence.add(new ZoomDescriptorComponent(this.ax));
            this.ax.setValueRange(d6 - d5 / 2.0, d5);
        } else {
            this.zoomSequence.add(new ZoomDescriptorComponent());
        }
        this.ignoreNotifications = bl;
        if (axis2 != null && axis2.getType() == 0) {
            this.zoomSequence.add(new ZoomDescriptorComponent(axis2));
            axis2.setValueRange(d3 - d4 / 2.0, d4);
        } else {
            this.zoomSequence.add(new ZoomDescriptorComponent());
        }
        this.updateObjects();
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void performZoomOut(int n, int n2) {
        int n3;
        if (Global.DEBUG > 0) {
            System.out.println("performZoomOut(" + n + "," + n2 + ") [zoomSequence.len=" + this.zoomSequence.size() + "]");
        }
        if ((n3 = this.zoomSequence.size() - 1) < 1) {
            return;
        }
        ZoomDescriptorComponent zoomDescriptorComponent = (ZoomDescriptorComponent)this.zoomSequence.get(n3 - 1);
        ZoomDescriptorComponent zoomDescriptorComponent2 = (ZoomDescriptorComponent)this.zoomSequence.get(n3);
        boolean bl = this.ignoreNotifications;
        this.ignoreNotifications = true;
        if (!zoomDescriptorComponent.dummy && zoomDescriptorComponent.axis != null) {
            zoomDescriptorComponent.axis.setValueRange(zoomDescriptorComponent.vBegin, zoomDescriptorComponent.vLen);
        }
        this.ignoreNotifications = bl;
        if (!zoomDescriptorComponent2.dummy && zoomDescriptorComponent2.axis != null) {
            zoomDescriptorComponent2.axis.setValueRange(zoomDescriptorComponent2.vBegin, zoomDescriptorComponent2.vLen);
        }
        this.zoomSequence.remove(zoomDescriptorComponent2);
        this.zoomSequence.remove(zoomDescriptorComponent);
        this.updateObjects();
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void resetZoom() {
        if (Global.DEBUG > 0) {
            System.out.println("resetZoom() [zoomSequence.len=" + this.zoomSequence.size() + "]");
        }
        if (this.zoomSequence.size() > 1) {
            ZoomDescriptorComponent zoomDescriptorComponent = (ZoomDescriptorComponent)this.zoomSequence.get(0);
            ZoomDescriptorComponent zoomDescriptorComponent2 = (ZoomDescriptorComponent)this.zoomSequence.get(1);
            boolean bl = this.ignoreNotifications;
            this.ignoreNotifications = true;
            if (this.ax != null && !zoomDescriptorComponent.dummy) {
                this.ax.setValueRange(zoomDescriptorComponent.vBegin, zoomDescriptorComponent.vLen);
            }
            this.ignoreNotifications = bl;
            if (this.ay != null && !zoomDescriptorComponent2.dummy) {
                this.ay.setValueRange(zoomDescriptorComponent2.vBegin, zoomDescriptorComponent2.vLen);
            }
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        this.zoomSequence.clear();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (Global.DEBUG > 0) {
            System.out.println("Event:" + mouseEvent);
        }
        this.baseDragX1 = this.baseDragX2 = mouseEvent.getX();
        this.baseDragY1 = this.baseDragY2 = mouseEvent.getY();
        this.qi.hide();
        this.selDrag = Common.isSelectTrigger(mouseEvent);
        this.zoomDrag = Common.isZoomTrigger(mouseEvent);
        this.moveDrag = Common.isMoveTrigger(mouseEvent);
        if (Global.DEBUG > 0) {
            System.out.println("BaseCanvas:mousePressed selection:" + this.selDrag + " zoom:" + this.zoomDrag + " move:" + this.moveDrag);
        }
        if (this.selDrag || this.allowDragZoom && this.zoomDrag || this.allowDragMove && this.moveDrag) {
            this.baseDrag = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (Global.DEBUG > 0) {
            System.out.println("Event:" + mouseEvent);
        }
        int n = this.baseDragX1;
        int n2 = this.baseDragY1;
        int n3 = this.baseDragX2;
        int n4 = this.baseDragY2;
        if (!this.baseDrag || n == mouseEvent.getX() && n2 == mouseEvent.getY()) {
            this.baseDrag = false;
            return;
        }
        if (this.baseDragX1 > this.baseDragX2) {
            n3 = this.baseDragX1;
            n = this.baseDragX2;
        }
        if (this.baseDragY1 > this.baseDragY2) {
            n4 = this.baseDragY1;
            n2 = this.baseDragY2;
        }
        Rectangle rectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
        this.baseDrag = false;
        this.setUpdateRoot(2);
        if (this.selDrag && this.pp != null) {
            boolean bl = true;
            if (Common.getSelectMode(mouseEvent) == 1) {
                bl = false;
            }
            if (Common.getSelectMode(mouseEvent) == 0) {
                this.m.selectNone();
            }
            PlotPrimitive[] plotPrimitiveArray = this.getPrimitivesIntersecting(rectangle);
            for (int i = 0; i < plotPrimitiveArray.length; ++i) {
                if (plotPrimitiveArray[i] == null) continue;
                plotPrimitiveArray[i].setMark(this.m, bl);
            }
            this.m.NotifyAll(new NotifyMsg(this.m, 4096));
            return;
        }
        if (this.zoomDrag) {
            this.performZoomIn(n, n2, n3, n4);
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.baseDrag) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n != this.baseDragX2 || n2 != this.baseDragY2) {
                this.baseDragX2 = n;
                this.baseDragY2 = n2;
                this.setUpdateRoot(2);
                this.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        Point point = this.getFrame().getLocation();
        Point point2 = this.getLocation();
        point.x += point2.x;
        point.y += point2.y;
        boolean bl = true;
        boolean bl2 = Common.isQueryTrigger(mouseEvent);
        boolean bl3 = Common.isExtQuery(mouseEvent);
        if (bl3) {
            PlotPrimitive plotPrimitive;
            this.inQuery = true;
            this.isExtQuery = true;
            if (this.pp != null && (plotPrimitive = this.getFirstPrimitiveContaining(this.mouseX, this.mouseY)) != null && plotPrimitive.isQueryable()) {
                if (this.useExtQuery) {
                    this.setQueryText(this.extQueryString);
                } else if (plotPrimitive.cases() > 0) {
                    if (plotPrimitive.getPrimaryCase() != -1) {
                        this.setQueryText(this.queryObject(plotPrimitive), plotPrimitive.getPrimaryCase());
                    } else {
                        this.setQueryText(this.queryObject(plotPrimitive), plotPrimitive.getCaseIDs());
                    }
                } else {
                    this.setQueryText(this.queryObject(plotPrimitive));
                }
                if (!this.showQuery) {
                    this.qi.setLocation(point.x + this.mouseX + 10, point.y + this.mouseY + 20);
                    this.qi.show();
                    bl = false;
                }
            }
            this.isExtQuery = false;
            this.setUpdateRoot(3);
            this.repaint();
        } else if (bl2) {
            this.inQuery = true;
            if (this.pp != null) {
                PlotPrimitive plotPrimitive = this.getFirstPrimitiveContaining(this.mouseX, this.mouseY);
                if (plotPrimitive != null && plotPrimitive.isQueryable()) {
                    if (plotPrimitive.cases() > 0) {
                        if (plotPrimitive.getPrimaryCase() != -1) {
                            this.setQueryText(this.queryObject(plotPrimitive), plotPrimitive.getPrimaryCase());
                        } else {
                            this.setQueryText(this.queryObject(plotPrimitive), plotPrimitive.getCaseIDs());
                        }
                    } else {
                        this.setQueryText(this.queryObject(plotPrimitive));
                    }
                } else {
                    String string = this.getAxisQuery(this.mouseX, this.mouseY);
                    if (string != null) {
                        this.setQueryText(string);
                    } else {
                        this.setQueryText(this.queryPlotSpace());
                    }
                }
                if (this.showQuery) {
                    this.qi.setLocation(point.x + this.mouseX + 10, point.y + this.mouseY + 20);
                    this.qi.show();
                    bl = false;
                }
            }
            this.setUpdateRoot(3);
            this.repaint();
        } else if (this.inQuery) {
            this.inQuery = false;
            this.setUpdateRoot(3);
            this.repaint();
        }
        if (bl) {
            this.qi.hide();
        }
    }

    protected String getAxisQuery(int n, int n2) {
        return null;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'P') {
            this.run(this, M_PRINT);
        }
        if (keyEvent.getKeyChar() == 'X') {
            this.run(this, "exportPGS");
        }
        if (keyEvent.getKeyChar() == 'C') {
            this.run(this, M_EXPORTCASES);
        }
        if (keyEvent.getKeyChar() == ',') {
            this.run(this, M_HALPHADOWN);
        }
        if (keyEvent.getKeyChar() == '.') {
            this.run(this, M_HALPHAUP);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 157 && this.allowZoom && !this.inZoom && !this.inQuery) {
            this.setCursor(Common.cur_zoom);
            this.inZoom = true;
        }
        if (this.useObjectTranparency) {
            if (n == 39) {
                this.run(this, M_ALPHAUP);
            }
            if (n == 37) {
                this.run(this, M_ALPHADOWN);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 157 && this.allowZoom && !this.inQuery) {
            this.setCursor(Common.cur_arrow);
            this.inZoom = false;
        }
    }

    public Object run(Object object, String string) {
        super.run(object, string);
        if (this.m != null) {
            this.m.run(object, string);
        }
        if (M_PRINT.equals(string)) {
            this.run(object, "exportPS");
        }
        if (M_ROTATE.equals(string)) {
            this.rotate(1);
        }
        if ("flip".equals(string) && this.allow180) {
            this.rotate(2);
        }
        if ("exit".equals(string)) {
            WinTracker.current.Exit();
        }
        if (M_EXPORTCASES.equals(string)) {
            SVar sVar;
            ArrayList<SVar> arrayList = new ArrayList<SVar>();
            int n = 0;
            while ((sVar = this.getData(n++)) != null) {
                arrayList.add(sVar);
            }
            if (arrayList.size() > 0) {
                SVar[] sVarArray = new SVar[arrayList.size()];
                arrayList.toArray(sVarArray);
                try {
                    PrintStream printStream = Tools.getNewOutputStreamDlg(this.myFrame, "Export selected cases to ...", "selected.txt");
                    if (printStream != null) {
                        int n2;
                        String string2 = sVarArray[0].getName();
                        for (n2 = 1; n2 < sVarArray.length; ++n2) {
                            string2 = string2 + "\t" + sVarArray[n2].getName();
                        }
                        printStream.println(string2);
                        n2 = sVarArray[0].size();
                        for (n = 0; n < n2; ++n) {
                            if (!this.m.at(n)) continue;
                            Object object2 = sVarArray[0].at(n);
                            string2 = object2 == null ? "NA" : object2.toString();
                            for (int i = 1; i < sVarArray.length; ++i) {
                                object2 = sVarArray[i].at(n);
                                string2 = string2 + "\t" + (object2 == null ? "NA" : object2.toString());
                            }
                            printStream.println(string2);
                        }
                        printStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (M_RESETZOOM.equals(string)) {
            this.resetZoom();
        }
        if (M_SONLYSELECTED.equals(string)) {
            this.MIsonlyselected.setLabel(this.showOnlyHilited ? "Show only selected cases" : "Show all cases");
            this.showOnlyHilited = !this.showOnlyHilited;
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_SEPERATEALPHAS.equals(string)) {
            this.MIseperatealphas.setLabel((this.seperateAlphas ? "Different" : "Same") + " transparency for hiliting.");
            this.seperateAlphas = !this.seperateAlphas;
            this.MIhalphadown.setEnabled(this.seperateAlphas);
            this.MIhalphaup.setEnabled(this.seperateAlphas);
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_HALPHADOWN.equals(string)) {
            float f = this.ppAlpha;
            this.ppAlphaH = this.alphaDown(this.ppAlphaH);
            if (this.ppAlpha != f) {
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
        if (M_HALPHAUP.equals(string)) {
            float f = this.ppAlpha;
            this.ppAlphaH = this.alphaUp(this.ppAlphaH);
            if (this.ppAlpha != f) {
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
        if (M_ALPHADOWN.equals(string)) {
            float f = this.ppAlpha;
            this.ppAlpha = this.alphaDown(this.ppAlpha);
            if (this.ppAlpha != f) {
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
        if (M_ALPHAUP.equals(string)) {
            float f = this.ppAlpha;
            this.ppAlpha = this.alphaUp(this.ppAlpha);
            if (this.ppAlpha != f) {
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
        if (M_TRANSHIGHL.equals(string)) {
            this.alphaHighlighting = !this.alphaHighlighting;
            this.MItransHighl.setLabel(this.alphaHighlighting ? "Opaque highlighting" : "Transparent highlighting");
            this.setUpdateRoot(1);
            this.repaint();
        }
        if (M_RESETCB.equals(string) && this.m.getSecCount() > 0) {
            this.m.resetSec();
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        if (M_SETCBBYSEL.equals(string)) {
            this.m.setSecBySelection(16, 17);
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        return null;
    }

    private float alphaUp(float f) {
        float f2 = f + (f > 0.2f ? 0.1f : 0.02f);
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    private float alphaDown(float f) {
        float f2 = f - (f > 0.2f ? 0.1f : 0.02f);
        if (f2 < 0.05f) {
            f2 = 0.05f;
        }
        return f2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        this.run(actionEvent.getSource(), actionEvent.getActionCommand());
    }

    public void setQueryText(String string) {
        if (string == null) {
            this.showQuery = false;
            return;
        }
        this.showQuery = true;
        this.qi.setContent(string);
    }

    public void setQueryText(String string, int n) {
        if (string == null) {
            this.showQuery = false;
            return;
        }
        this.showQuery = true;
        this.qi.setContent(string, n);
    }

    public void setQueryText(String string, int[] nArray) {
        if (string == null) {
            this.showQuery = false;
            return;
        }
        this.showQuery = true;
        this.qi.setContent(string, nArray);
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
        this.xLabels.show = bl;
        this.yLabels.show = bl;
    }

    protected PlotPrimitive[] getPrimitivesContaining(int n, int n2) {
        PlotPrimitive[] plotPrimitiveArray = new PlotPrimitive[this.pp.length];
        int n3 = 0;
        for (int i = 0; i < this.pp.length; ++i) {
            if (this.pp[i] == null || !this.pp[i].contains(n, n2)) continue;
            plotPrimitiveArray[n3++] = this.pp[i];
        }
        PlotPrimitive[] plotPrimitiveArray2 = new PlotPrimitive[n3];
        System.arraycopy(plotPrimitiveArray, 0, plotPrimitiveArray2, 0, n3);
        return plotPrimitiveArray2;
    }

    protected PlotPrimitive getFirstPrimitiveContaining(int n, int n2) {
        for (int i = 0; i < this.pp.length; ++i) {
            if (this.pp[i] == null || !this.pp[i].contains(n, n2)) continue;
            return this.pp[i];
        }
        return null;
    }

    protected PlotPrimitive[] getPrimitivesIntersecting(Rectangle rectangle) {
        PlotPrimitive[] plotPrimitiveArray = new PlotPrimitive[this.pp.length];
        int n = 0;
        for (int i = 0; i < this.pp.length; ++i) {
            if (this.pp[i] == null || !this.pp[i].intersects(rectangle)) continue;
            plotPrimitiveArray[n++] = this.pp[i];
        }
        PlotPrimitive[] plotPrimitiveArray2 = new PlotPrimitive[n];
        System.arraycopy(plotPrimitiveArray, 0, plotPrimitiveArray2, 0, n);
        return plotPrimitiveArray2;
    }

    public double[] getBoundValues() {
        if (this.pp == null) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.pp.length; ++i) {
            d3 = this.pp[i].cases();
            if (d < d3) {
                d = d3;
            }
            if (!(d2 > d3)) continue;
            d2 = d3;
        }
        return new double[]{d2, d};
    }

    public boolean adjustMargin(PoGraSS poGraSS) {
        int n = this.yLabels.getMaxBoundingBoxWidth(poGraSS) + 5;
        if (n > 0 && n < this.maxMLeft && this.mLeft < n) {
            this.mLeft = n;
            return true;
        }
        return false;
    }

    protected void createMenu(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) {
        String[] stringArray2 = new String[(stringArray == null ? 0 : stringArray.length) + 37];
        int n = 0;
        stringArray2[n++] = "+";
        stringArray2[n++] = "File";
        stringArray2[n++] = "~File.Graph";
        stringArray2[n++] = "~Edit";
        if (stringArray != null && stringArray.length > 0 || bl || bl2 || bl3) {
            stringArray2[n++] = "+";
            stringArray2[n++] = "View";
            if (bl) {
                stringArray2[n++] = "@RRotate";
                stringArray2[n++] = M_ROTATE;
            }
            if (bl2) {
                stringArray2[n++] = "@HReset zoom";
                stringArray2[n++] = M_RESETZOOM;
            }
            stringArray2[n++] = "Show only selected cases";
            stringArray2[n++] = M_SONLYSELECTED;
            this.useObjectTranparency = bl3;
            if (bl3) {
                stringArray2[n++] = "-";
                stringArray2[n++] = "More transparent (left)";
                stringArray2[n++] = M_ALPHADOWN;
                stringArray2[n++] = "More opaque (right)";
                stringArray2[n++] = M_ALPHAUP;
                stringArray2[n++] = "Transparent highlighting";
                stringArray2[n++] = M_TRANSHIGHL;
                stringArray2[n++] = "Different transparency for hiliting.";
                stringArray2[n++] = M_SEPERATEALPHAS;
                stringArray2[n++] = "Hiliting more transparent.";
                stringArray2[n++] = M_HALPHADOWN;
                stringArray2[n++] = "Hiliting more opaque.";
                stringArray2[n++] = M_HALPHAUP;
            }
            stringArray2[n++] = "-";
            if (bl4) {
                stringArray2[n++] = "Set Colors (CB)";
                stringArray2[n++] = M_SETCB1;
                stringArray2[n++] = "Set Colors (rainbow)";
                stringArray2[n++] = M_SETCB64;
            }
            stringArray2[n++] = "Paint selection";
            stringArray2[n++] = M_SETCBBYSEL;
            stringArray2[n++] = "Clear Colors";
            stringArray2[n++] = M_RESETCB;
            if (stringArray != null) {
                stringArray2[n++] = "-";
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[n++] = stringArray[i];
                }
            }
        }
        stringArray2[n++] = "~Window";
        stringArray2[n++] = "0";
        EzMenu.getEzMenu(frame, this, stringArray2);
        if (stringArray != null) {
            String[] stringArray3 = stringArray;
            String[] stringArray4 = new String[stringArray3.length + 1];
            System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
            stringArray4[stringArray4.length - 1] = "0";
            stringArray3 = null;
            this.pop = EzMenu.getEzPopup(frame, this, stringArray4);
        } else {
            this.pop = null;
        }
        this.MIsonlyselected = EzMenu.getItem(frame, M_SONLYSELECTED);
        this.MIseperatealphas = EzMenu.getItem(frame, M_SEPERATEALPHAS);
        this.MIhalphadown = EzMenu.getItem(frame, M_HALPHADOWN);
        if (this.MIhalphadown != null) {
            this.MIhalphadown.setEnabled(false);
        }
        this.MIhalphaup = EzMenu.getItem(frame, M_HALPHAUP);
        if (this.MIhalphaup != null) {
            this.MIhalphaup.setEnabled(false);
        }
    }

    public void setExtQueryString(String string) {
        this.extQueryString = string;
        this.useExtQuery = true;
    }

    public void useExtQuery(boolean bl) {
        this.useExtQuery = bl;
    }

    public void setDefaultMargins(int[] nArray) {
        if (nArray != null || nArray.length >= 4) {
            this.defaultMLeft = nArray[0];
            this.defaultMRight = nArray[1];
            this.defaultMTop = nArray[2];
            this.defaultMBottom = nArray[3];
            int n = 0;
            if (nArray.length >= 8) {
                n = 4;
            }
            this.defaultMLeft1 = nArray[n + 0];
            this.defaultMRight1 = nArray[n + 1];
            this.defaultMTop1 = nArray[n + 2];
            this.defaultMBottom1 = nArray[n + 3];
            if (nArray.length >= 12) {
                n = 8;
            }
            this.defaultMLeft2 = nArray[n + 0];
            this.defaultMRight2 = nArray[n + 1];
            this.defaultMTop2 = nArray[n + 2];
            this.defaultMBottom2 = nArray[n + 3];
            if (nArray.length >= 16) {
                n = 12;
            } else if (nArray.length >= 16) {
                n = 4;
            }
            this.defaultMLeft3 = nArray[n + 0];
            this.defaultMRight3 = nArray[n + 1];
            this.defaultMTop3 = nArray[n + 2];
            this.defaultMBottom3 = nArray[n + 3];
        }
        switch (this.orientation) {
            case 0: {
                this.mLeft = this.defaultMLeft;
                this.mRight = this.defaultMRight;
                this.mTop = this.defaultMTop;
                this.mBottom = this.defaultMBottom;
                break;
            }
            case 1: {
                this.mLeft = this.defaultMLeft1;
                this.mRight = this.defaultMRight1;
                this.mTop = this.defaultMTop1;
                this.mBottom = this.defaultMBottom1;
                break;
            }
            case 2: {
                this.mLeft = this.defaultMLeft2;
                this.mRight = this.defaultMRight2;
                this.mTop = this.defaultMTop2;
                this.mBottom = this.defaultMBottom2;
                break;
            }
            case 3: {
                this.mLeft = this.defaultMLeft3;
                this.mRight = this.defaultMRight3;
                this.mTop = this.defaultMTop3;
                this.mBottom = this.defaultMBottom3;
            }
        }
    }

    public void addXLabels(PoGraSS poGraSS, Axis axis, String[] stringArray, int n, int[] nArray, boolean bl, boolean bl2) {
        this.addXLabels(poGraSS, axis, stringArray, new int[]{n}, nArray, bl, bl2, false);
    }

    public void addXLabels(PoGraSS poGraSS, Axis axis, String[] stringArray, int n, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        this.addXLabels(poGraSS, axis, stringArray, new int[]{n}, nArray, bl, bl2, bl3);
    }

    public void addXLabels(PoGraSS poGraSS, Axis axis, String[] stringArray, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        this.addXLabels(poGraSS, axis, stringArray, nArray, nArray2, bl, bl2, false);
    }

    public void addXLabels(PoGraSS poGraSS, Axis axis, String[] stringArray, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3) {
        double d = 0.0;
        boolean bl4 = true;
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[Math.min(nArray.length - 1, i)];
            if (this.orientation == 0) {
                String string = null;
                if (n < poGraSS.getWidthEstimate(stringArray[i])) {
                    if (d <= 0.0) {
                        String string2 = Common.getTriGraph(stringArray[i]);
                        if (!bl2 || n < poGraSS.getWidthEstimate(string2) + 10) {
                            d = poGraSS.getWidthEstimate(string2) - n + 10;
                            if (bl4 && bl2) {
                                string = string2;
                            }
                        } else {
                            string = string2;
                            bl4 = false;
                        }
                    } else {
                        d -= (double)n;
                        bl4 = true;
                    }
                } else {
                    string = stringArray[i];
                    bl4 = false;
                    if (d > 0.0) {
                        d -= (double)n;
                    }
                }
                if (string != null) {
                    this.xLabels.add(nArray2[i], bl3 ? (double)(this.mTop / 2) : (double)(this.getBounds().height - this.mBottom / 2), 0.5, 0.3, string);
                }
                if (!bl) continue;
                int n2 = bl3 ? this.mTop - 3 : this.getBounds().height - this.mBottom;
                poGraSS.drawLine(nArray2[i], n2, nArray2[i], n2 + 3);
                continue;
            }
            int n3 = this.mLeft - 3;
            this.yLabels.add((double)n3, (double)nArray2[i], 1.0, 0.5, n, stringArray[i]);
            if (!bl) continue;
            poGraSS.drawLine(this.mLeft - 3, nArray2[i], this.mLeft, nArray2[i]);
        }
    }

    public void addYLabels(PoGraSS poGraSS, Axis axis, boolean bl, boolean bl2) {
        this.addYLabels_internal(poGraSS, axis, null, bl, bl2);
    }

    public void addYLabels(PoGraSS poGraSS, Axis axis, SVar sVar, boolean bl, boolean bl2) {
        this.addYLabels_internal(poGraSS, axis, sVar, bl, bl2);
    }

    public void addYLabels(PoGraSS poGraSS, Axis axis, String[] stringArray, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        double d = this.rotateYLabelsBy * Math.PI / 180.0;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int i = 0; i < nArray2.length; ++i) {
            double[] dArray = this.rotateAlignment(poGraSS.getWidthEstimate(stringArray[i]), poGraSS.getHeightEstimate(stringArray[i]), d2, d3);
            this.yLabels.add(this.mLeft - 4, nArray2[i], dArray[0], dArray[1], this.mLeft - 4, nArray[i], stringArray[i], this.rotateYLabels ? this.rotateYLabelsBy : 0.0);
        }
    }

    private void addYLabels_internal(PoGraSS poGraSS, Axis axis, SVar sVar, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        double d = axis.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist);
        int n = 0;
        for (double d2 = axis.getSensibleTickStart(d); d2 < axis.vBegin + axis.vLen; d2 += d) {
            if (sVar == null) {
                arrayList.add(axis.getDisplayableValue(d2));
            } else {
                arrayList.add(sVar.getCatAt((int)(d2 + 0.5)).toString());
            }
            arrayList2.add(new Integer(axis.getValuePos(d2)));
            ++n;
        }
        int[] nArray = new int[arrayList2.size()];
        n = 0;
        ListIterator listIterator = arrayList2.listIterator();
        while (listIterator.hasNext()) {
            nArray[n++] = (Integer)listIterator.next();
        }
        if (nArray.length > 1) {
            arrayList3.add(new Integer(2 * Math.min(Math.abs(nArray[0] - this.mTop), Math.abs(nArray[1] - nArray[0]) / 2)));
            for (n = 1; n < nArray.length - 1; ++n) {
                arrayList3.add(new Integer(2 * Math.min(Math.abs(nArray[n] - nArray[n - 1]) / 2, Math.abs(nArray[n + 1] - nArray[n]) / 2)));
            }
            arrayList3.add(new Integer(2 * Math.min(Math.abs(this.getBounds().height - this.mBottom - nArray[nArray.length - 1]), Math.abs(nArray[nArray.length - 1] - nArray[nArray.length - 2]) / 2)));
        } else {
            arrayList3.add(new Integer(Math.abs(this.getBounds().height - this.mBottom - this.mTop)));
        }
        int n2 = bl2 ? this.getDefaultMLeft() - 5 : -1;
        int n3 = this.mLeft - 5;
        double d3 = this.rotateYLabelsBy * Math.PI / 180.0;
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        for (n = 0; n < nArray.length; ++n) {
            double d6;
            double d7;
            if (this.rotateYLabels) {
                double[] dArray = this.rotateAlignment(poGraSS.getWidthEstimate((String)arrayList.get(n)), poGraSS.getHeightEstimate((String)arrayList.get(n)), d4, d5);
                d7 = dArray[0];
                d6 = dArray[1];
            } else {
                d7 = 1.0;
                d6 = 0.5;
            }
            this.yLabels.add(n3, nArray[n], d7, d6, n2, (Integer)arrayList3.get(n), (String)arrayList.get(n), this.rotateYLabels ? this.rotateYLabelsBy : 0.0);
            if (!bl) continue;
            poGraSS.drawLine(this.mLeft - 2, nArray[n], this.mLeft, nArray[n]);
        }
    }

    public int getMBottom() {
        return this.mBottom;
    }

    public void setMBottom(int n) {
        this.mBottom = n;
        this.updateGeometry = true;
    }

    public int getMLeft() {
        return this.mLeft;
    }

    public void setMLeft(int n) {
        this.mLeft = n;
        this.updateGeometry = true;
    }

    public int getMRight() {
        return this.mRight;
    }

    public void setMRight(int n) {
        this.mRight = n;
        this.updateGeometry = true;
    }

    public int getMTop() {
        return this.mTop;
    }

    public void setMTop(int n) {
        this.mTop = n;
        this.updateGeometry = true;
    }

    protected void setColors(PPrimBase pPrimBase) {
        if (this.fillColor != null) {
            pPrimBase.fillColor = this.fillColor;
        }
        if (this.fillColorSel != null) {
            pPrimBase.fillColorSel = this.fillColorSel;
        }
        if (this.borderColor != null) {
            pPrimBase.borderColor = this.borderColor;
        }
        if (this.borderColorSel != null) {
            pPrimBase.borderColorSel = this.borderColorSel;
        }
    }

    protected void endAddingLabels() {
        this.xLabels.finishAdd();
        this.yLabels.finishAdd();
    }

    protected void startAddingLabels() {
        this.xLabels.clear();
        this.yLabels.clear();
    }

    protected int getDefaultMLeft() {
        int n;
        switch (this.orientation) {
            case 0: {
                n = this.defaultMLeft;
                break;
            }
            case 1: {
                n = this.defaultMLeft1;
                break;
            }
            case 2: {
                n = this.defaultMLeft2;
                break;
            }
            default: {
                n = this.defaultMLeft3;
            }
        }
        return n;
    }

    protected void setAyDefaultGeometry() {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        switch (this.orientation) {
            case 0: {
                this.ay.setGeometry(1, n2 - this.mBottom, this.mTop + this.mBottom - n2);
                break;
            }
            case 1: {
                this.ay.setGeometry(0, this.mLeft, n - this.mLeft - this.mRight);
                break;
            }
            case 2: {
                this.ay.setGeometry(1, this.mTop, n2 - this.mTop - this.mBottom);
                break;
            }
            case 3: {
                this.ay.setGeometry(0, n - this.mRight, this.mLeft + this.mRight - n);
            }
        }
    }

    protected void setAxDefaultGeometry() {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        switch (this.orientation) {
            case 0: {
                this.ax.setGeometry(0, this.mLeft, n - this.mLeft - this.mRight);
                break;
            }
            case 1: {
                this.ax.setGeometry(1, this.mTop, n2 - this.mTop - this.mBottom);
                break;
            }
            case 2: {
                this.ax.setGeometry(0, n - this.mRight, this.mLeft + this.mRight - n);
                break;
            }
            case 3: {
                this.ax.setGeometry(1, n2 - this.mBottom, this.mTop + this.mBottom - n2);
            }
        }
    }

    private double[] rotateAlignment(double d, double d2, double d3, double d4) {
        double[] dArray = new double[2];
        double d5 = this.rotateYLabelsBy < 0.0 ? this.rotateYLabelsBy - (double)((int)(this.rotateYLabelsBy / 360.0 + 1.0) * 360) : this.rotateYLabelsBy - (double)((int)(this.rotateYLabelsBy / 360.0) * 360);
        if (d5 < 90.0) {
            double d6 = (d2 * d4 - d * d3) / 2.0;
            dArray[0] = 1.0 + d3 * d6 / d;
            dArray[1] = d4 * d6 / d2;
        } else if (d5 < 180.0) {
            double d7 = (d2 * d4 + d * d3) / 2.0;
            dArray[0] = d3 * d7 / d;
            dArray[1] = d4 * d7 / d2;
        } else if (d5 < 270.0) {
            double d8 = (d2 * d4 - d * d3) / 2.0;
            dArray[0] = -d3 * d8 / d;
            dArray[1] = 1.0 - d4 * d8 / d2;
        } else {
            double d9 = (d2 * d4 + d * d3) / 2.0;
            dArray[0] = 1.0 - d3 * d9 / d;
            dArray[1] = 1.0 - d4 * d9 / d2;
        }
        return dArray;
    }

    class ZoomDescriptorComponent {
        double vBegin;
        double vLen;
        int gBegin;
        int gLen;
        int dc;
        boolean dummy;
        Axis axis;

        ZoomDescriptorComponent() {
            this.dummy = true;
        }

        ZoomDescriptorComponent(Axis axis) {
            this.vBegin = axis.vBegin;
            this.vLen = axis.vLen;
            this.gBegin = axis.gBegin;
            this.gLen = axis.gLen;
            this.dc = axis.datacount;
            this.axis = axis;
            this.dummy = false;
        }
    }
}

