% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfProb}
\alias{ipfProb}
\title{This function implements a probabilistic algorithm}
\usage{
ipfProb(train, test, groups, k = 3, FUN = sum, delta = 1, ...)
}
\arguments{
\item{train}{a data frame containing the RSSI vectors of the training set}

\item{test}{a data frame containing the RSSI vectors of the test set}

\item{groups}{a numeric vector of length = nrow(train) containing the group index
for the training vectors}

\item{k}{the k parameter for the algorithm (number of similar neighbours)}

\item{FUN}{function to compute the similarity measurement. Default is 'sum'}

\item{delta}{parameter delta}

\item{...}{additional parameters for provided function FUN}
}
\value{
An S4 class object of type ipfModel, with the following slots:
                 neighbours -> a matrix with k columns and nrow(test) rows, with the
                               k most similar training observation for each test observation
                 weights ->    a matrix with k columns and nrow(test) rows, with the weights
                 distances ->  a matrix with k columns and nrow(test) rows, with the distances
                 k ->          k parameter
                 groups ->     the group index for each training observation
}
\description{
This function implements a probabilistic algorithm
}
\examples{

    groups <- ipfGroup(ipftrain, LONGITUDE, LATITUDE)
    model <- ipfProb(ipftrain[, 1:168], ipftest[, 1:168], groups)

    groups <- ipfGroup(ipftrain, LONGITUDE, LATITUDE)
    model <- ipfProb(ipftrain[, 1:168], ipftest[, 1:168], groups, k = 9, delta = 10)

}

