% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipu_nr.R
\name{ipu_nr}
\alias{ipu_nr}
\title{Iterative Proportional Updating (Newton-Raphson)}
\usage{
ipu_nr(
  primary_seed,
  primary_targets,
  secondary_seed = NULL,
  secondary_targets = NULL,
  target_priority = 1e+07,
  relative_gap = 0.01,
  max_iterations = 100,
  absolute_diff = 10,
  weight_floor = 1e-05,
  verbose = FALSE,
  max_ratio = 10000,
  min_ratio = 1e-04
)
}
\arguments{
\item{primary_seed}{In population synthesis or household survey expansion, 
this would be the household seed table (each record would represent a 
household). It could also be a trip table, where each row represents an 
origin-destination pair. Must contain a \code{pid} ("primary ID") field
that is unique for each row. Must also contain a geography field that
starts with "geo_".}

\item{primary_targets}{A \code{named list} of data frames.  Each name in the 
list defines a marginal dimension and must match a column from the 
\code{primary_seed} table. The data frame associated with each named list
element must contain a geography field (starts with "geo_"). Each row in
the target table defines a new geography (these could be TAZs, tracts,
clusters, etc.). The other column names define the marginal categories that
targets are provided for. The vignette provides more detail.}

\item{secondary_seed}{Most commonly, if the primary_seed describes households, the 
secondary seed table would describe a unique person with each row. Must
also contain the \code{pid} column that links each person to their 
respective household in \code{primary_seed}. Must not contain any geography
fields (starting with "geo_").}

\item{secondary_targets}{Same format as \code{primary_targets}, but they constrain 
the \code{secondary_seed} table.}

\item{target_priority}{This argument controls how quickly each set of 
  targets is relaxed. In other words: how important it is to match the target
  exactly. Defaults to \code{10,000,000}, which means that all targets should
  be matched exactly.

\describe{
  \item{\code{real}}{This priority value will be used for each target table.}
  \item{\code{named list}}{Each named entry must match an entry in either
  \code{primary_targets} or \code{secondary_targets} and have a \code{real}.
  This priority will be applied to that target table. Any targets not in the
  list will default to \code{10,000,000}.}
  \item{\code{data.frame}}{Column \code{target} must have values that match an
  entry in either \code{primary_targets} or \code{secondary_targets}. Column 
  \code{priority} contains the values to use for priority. Any targets not in
  the table will default to \code{10,000,000}.}
}}

\item{relative_gap}{After each iteration, the weights are compared to the
previous weights and the %RMSE is calculated. If the %RMSE is less than
the \code{relative_gap} threshold, then the process terminates.}

\item{max_iterations}{maximum number of iterations to perform, even if 
\code{relative_gap} is not reached.}

\item{absolute_diff}{Upon completion, the \code{ipu()} function will report
the worst-performing marginal category and geography based on the percent
difference from the target. \code{absolute_diff} is a threshold below which
percent differences don't matter.

For example, if if a target value was 2, and the expanded weights equaled
1, that's a 100% difference, but is not important because the absolute value
is only 1.

Defaults to 10.}

\item{weight_floor}{Minimum weight to allow in any cell to prevent zero
weights. Set to .0001 by default.  Should be arbitrarily small compared to
your seed table weights.}

\item{verbose}{Print iteration details and worst marginal stats upon 
completion? Default \code{FALSE}.}

\item{max_ratio}{\code{real} number. The average weight per seed record is
calculated by dividing the total of the targets by the number of records.
The max_scale caps the maximum weight at a multiple of that average. Defaults
to \code{10000} (basically turned off).}

\item{min_ratio}{\code{real} number. The average weight per seed record is
calculated by dividing the total of the targets by the number of records.
The min_scale caps the minimum weight at a multiple of that average. Defaults
to \code{0.0001} (basically turned off).}
}
\value{
a \code{named list} with the \code{primary_seed} with weight, a 
  histogram of the weight distribution, and two comparison tables to aid in
  reporting.
}
\description{
List balancing similar to \code{\link{ipu}}, but using the
  Newton-Raphson approach to optimization. Created primarily as a point of
  comparison for \code{ipu}.
}
\keyword{internal}
