% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_network.R
\name{network_in_network}
\alias{network_in_network}
\alias{is_supernet}
\alias{is_subnet}
\alias{overlaps}
\title{Network membership of other networks}
\usage{
is_supernet(network, other)

is_subnet(network, other)

overlaps(network, other)
}
\arguments{
\item{network}{An \code{\link{ip_network}} vector}

\item{other}{An \code{\link{ip_network}} vector}
}
\value{
A logical vector
}
\description{
\code{is_supernet()} and \code{is_subnet()} check if one network is a true supernet or
subnet of another network; \code{overlaps()} checks for any overlap between two
networks.
}
\examples{
net1 <- ip_network("192.168.1.128/30")
net2 <- ip_network("192.168.1.0/24")

is_supernet(net1, net2)

is_subnet(net1, net2)

overlaps(net1, net2)
}
\seealso{
Use \code{\link[=is_within]{is_within()}} to check if an \code{\link{ip_address}} is within an \code{\link{ip_network}}.

Use \code{\link[=supernet]{supernet()}} and \code{\link[=subnets]{subnets()}} to traverse the network hierarchy.
}
