% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_mask.R
\name{netmask}
\alias{netmask}
\alias{prefix_length}
\alias{hostmask}
\alias{prefix_length.ip_network}
\alias{netmask.ip_network}
\alias{hostmask.ip_network}
\alias{prefix_length.ip_interface}
\alias{netmask.ip_interface}
\alias{hostmask.ip_interface}
\alias{prefix_length.default}
\alias{netmask.default}
\alias{hostmask.default}
\title{Network mask}
\usage{
prefix_length(...)

netmask(...)

hostmask(...)

\method{prefix_length}{ip_network}(x, ...)

\method{netmask}{ip_network}(x, ...)

\method{hostmask}{ip_network}(x, ...)

\method{prefix_length}{ip_interface}(x, ...)

\method{netmask}{ip_interface}(x, ...)

\method{hostmask}{ip_interface}(x, ...)

\method{prefix_length}{default}(mask, ...)

\method{netmask}{default}(prefix_length, is_ipv6, ...)

\method{hostmask}{default}(prefix_length, is_ipv6, ...)
}
\arguments{
\item{...}{Arguments to be passed to other methods}

\item{x}{An \code{\link{ip_network}} or \code{\link{ip_interface}} vector}

\item{mask}{An \code{\link{ip_address}} vector of netmasks and/or hostmasks. Ambiguous
cases (all zeros, all ones) are treated as netmasks.}

\item{prefix_length}{An integer vector}

\item{is_ipv6}{A logical vector}
}
\value{
\itemize{
\item \code{prefix_length()} returns an integer vector
\item \code{netmask()} and \code{hostmask()} return an \code{\link{ip_address}} vector
}
}
\description{
\code{prefix_length()}, \code{netmask()} and \code{hostmask()} extract different (but
equivalent) representations of the network mask. They accept an
\code{\link{ip_network}} or \code{\link{ip_interface}} vector.

The functions can also convert between these alternative representations.
For example, \code{prefix_length()} can infer the prefix length from an
\code{\link{ip_address}} vector of netmasks and/or hostmasks, while \code{netmask()} and
\code{hostmask()} can accept a vector of prefix lengths.
}
\examples{
x <- ip_network(c("192.168.0.0/22", "2001:db00::0/26"))

prefix_length(x)

netmask(x)

hostmask(x)

# construct netmask/hostmask from prefix length
netmask(c(22L, 26L), c(FALSE, TRUE))

hostmask(c(22L, 26L), c(FALSE, TRUE))

# extract prefix length from netmask/hostmask
prefix_length(ip_address(c("255.255.255.0", "0.255.255.255")))

# invalid netmask/hostmask raise a warning and return NA
prefix_length(ip_address("255.255.255.1"))
}
\seealso{
\code{\link[=max_prefix_length]{max_prefix_length()}}
}
