% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_exclude.R
\name{exclude_networks}
\alias{exclude_networks}
\title{Remove networks from others}
\usage{
exclude_networks(include, exclude)
}
\arguments{
\item{include}{An \code{\link{ip_network}} vector}

\item{exclude}{An \code{\link{ip_network}} vector}
}
\value{
An \code{\link{ip_network}} vector
}
\description{
\code{exclude_networks()} takes lists of networks to include and exclude. It then
calculates the address ranges that are included but not excluded (similar to
\code{\link[=setdiff]{setdiff()}}), and finally returns the minimal set of networks needed to
describe the remaining address ranges.
}
\examples{
exclude_networks(ip_network('192.0.2.0/28'), ip_network('192.0.2.1/32'))

exclude_networks(ip_network('192.0.2.0/28'), ip_network('192.0.2.15/32'))
}
\seealso{
\code{\link[=collapse_networks]{collapse_networks()}}, \code{\link[=setdiff]{setdiff()}}
}
