% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_do_fit.R
\name{do_fit.pk}
\alias{do_fit.pk}
\title{Do fitting}
\usage{
\method{do_fit}{pk}(obj, n_cores = NULL, rate_names = NULL, max_multiplier = NULL, ...)
}
\arguments{
\item{obj}{A [pk] object.}

\item{n_cores}{Number of cores used for parallel computing.}

\item{rate_names}{The names of the rate units. Leave NULL to utilize default 1/hour.}

\item{max_multiplier}{Numeric value for upper prediction limit (this number multiplied
by maximum concentrations in each experiment). Default set to NULL does not apply this limit.}

\item{...}{Additional arguments. Not currently in use.}
}
\value{
The same [pk] object, with element `fit` containing the fitted
  results for each model in `stat_model`.
}
\description{
Fit PK model(s) for a `pk` object
}
\details{
This function estimates the parameters for each model in `stat_model` from
the data, using numerical optimization implemented in [optimx::optimx()]. The
optimization is done by maximizing the log-likelihood function implemented in
[log_likelihood()] (technically, by minimizing the negative log-likelihood).
Only the non-excluded observations are used.

Due to limitations of [optimx::optimx()], the log-likelihood function is
forced to return finite values during this optimization. Impossible
combinations of parameters (e.g., parameter values that produce negative
predicted concentrations) should have a log-likelihood of `-Inf`, but due to
this limitation, they instead have a log-likelihood of `-Machine.doublexmax`.
This limitation means that the log-likelihood function is flat in regions of
impossible parameter values. It is unlikely, but possible, that the optimizer
might get "stuck" in such a flat region -- report convergence, but return a
"bad" set of parameter values that produces non-physical predictions.

Before trusting the results of any fit, it is recommended to check the
log-likelihood using [logLik()] and the Akaike Information Criterion using
[AIC()], which check the log-likelihood *without* forcing it to return finite
values.
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
