% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkproto_facet_data.R
\name{facet_data}
\alias{facet_data}
\title{Facet a PK fit}
\usage{
facet_data(facets = vars(Chemical, Species), ...)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by [dplyr::vars()],
defining groups of data that will each be fitted separately. These
variables should appear in the *original* data (i.e., the `data` argument
to [pk()]).}

\item{...}{Additional arguments, not currently used.}
}
\value{
An object of class `c("pkproto", "pk_facet_data")`. Under the hood, a
  named  `list` containing the arguments provided to this function. Almost
  always added to a [pk()] object using [`+.pk`].
}
\description{
Create a "faceted" [pk()] object.
}
\details{
This function automates the process of doing PK fitting in "batch mode", when
you have multiple concentration-dose-time datasets to fit, and you want to
fit them all using the same set of instructions.

When you do something like

```
pk_cvt <- pk(cvt) +
 facet_data(
 facets = vars(
 chemicals_analyzed.dsstox_substance_id,
subjects.species_harmonized
)
)
```

Now `pk_cvt` is an object of class `pk_faceted`: under the hood, a
[tibble::tibble()] with one row for each group defined by a unique
combination of the faceting variables, and a `list` column containing a
[pk()] object corresponding to each group.

All of the [pk()] objects in the `list` column contain the same set of
instructions, and they will all have the same status (*i.e.*, they are all in
the same stage of the workflow at the same time). The only thing different
among them is the data.

If you call a `pk` method on a `pk_faceted` object, the method will be
applied in turn to the [pk()] object for each group.

If the method returns a [pk()] object (e.g. [preprocess_data.pk()],
[data_info.pk()], [prefit.pk()], and [fit.pk()]), then the result for a
`pk_faceted` object will be another `pk_faceted` object.

If the method returns something other than a [pk()] object (e.g. [coef.pk()],
[coef_sd.pk()], [residuals.pk()], [predict.pk()], ...) then the result for a
`pk_faceted` object will simply be a [tibble::tibble()] with a `list` column
containing the result for each group -- it won't have class `pk_faceted`.

This function is named by analogy to [ggplot2::facet_wrap()] and
[ggplot2::facet_grid()]. Those functions split up a dataset into groups by
one or more `factor` variables, and produce a "faceted" grid of plots for
each group of data. This function does an analogous thing for a [pk()]
analysis. The dataset is split into groups by the unique combinations of
variables in `facets`. For each group, a separate [pk()] object is created,
using the instructions provided by the user. When methods like
[preprocess_data()], [data_info()], [prefit()], and [fit()] are called on the
resulting "faceted"
}
\author{
Caroline Ring, Gilbert Padilla Mercado, Paul Kruse
}
