% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predFit.R
\name{predFit}
\alias{predFit}
\alias{predFit.lm}
\alias{predFit.lme}
\alias{predFit.nls}
\title{Predictions from a Fitted Model}
\usage{
predFit(object, ...)

\method{predFit}{lm}(object, newdata, se.fit = FALSE, interval = c("none",
  "confidence", "prediction"), level = 0.95, adjust = c("none",
  "Bonferroni", "Scheffe"), k, ...)

\method{predFit}{nls}(object, newdata, se.fit = FALSE, interval = c("none",
  "confidence", "prediction"), level = 0.95, adjust = c("none",
  "Bonferroni", "Scheffe"), k, ...)

\method{predFit}{lme}(object, newdata, se.fit = FALSE, ...)
}
\arguments{
\item{object}{An object that inherits from class \code{"lm"}, \code{"glm"},
\code{"nls"}, or \code{"lme"}.}

\item{...}{Additional optional arguments. At present, no optional arguments 
are used.}

\item{newdata}{An optional data frame in which to look for variables with 
which to predict. If omitted, the fitted values are used.}

\item{se.fit}{A logical vaue indicating if standard errors are required. Default
is \code{FALSE}.}

\item{interval}{Type of interval to be calculated. Can be one of "none" 
(default), "confidence", or "prediction". Default is \code{"none"}.}

\item{level}{A numeric scalar between 0 and 1 giving the confidence level for 
the intervals (if any) to be calculated. Default is \code{0.95}.}

\item{adjust}{A logical value indicating if an adjustment should be made to
the critical value used in calculating the confidence interval. This is 
useful for when the calibration curve is to be used multiple, say k, times.
Default is \code{FALSE}.}

\item{k}{The number times the calibration curve is to be used for computing 
a confidence interval. Only needed when \code{adjust = "Bonferroni"}.}
}
\description{
Generic prediction method for various types of fitted models. (For internal 
use only.)
}

