% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iCoxph.R
\name{iCoxph.start}
\alias{iCoxph.start}
\title{Auxiliary for Starting iCoxph Fitting}
\usage{
iCoxph.start(beta_vec = NULL, beta_mat = NULL,
             methods = c("nearest_hazard", "unit_hazard"), ...)
}
\arguments{
\item{beta_vec}{A numeric vector for starting values of coefficient
estimates. The default values are the coefficient estimates from the
regular Cox model only fitting on records without uncertainty.  If
censoring rate among subjects having unique certain records is extremely
high (> 99%) or such as perfect seperation problem between event
indicator and one predictor, the starting values will be reset to be all
zeros.}

\item{beta_mat}{A numeric matrix that consists of additional starting values
of coefficient estimates in columns.  The default value is \code{NULL}.}

\item{methods}{A character vector specifying the initialization methods for
probabilities of uncertain records being true.  The available methods
are \code{"nearest_hazard"} for initializing baseline hazard by nearest
(left) neighbor, and \code{"unit_hazard"} for initializing unit baseline
hazard.  Partial matching on method names is supported for ease of
typing.  By default, both methods are used.  See Wang et al. (2019+) for
details of the initialization methods.}

\item{...}{Other arguments for future usage.  A warning will be thrown if
any invalid argument is specified.}
}
\value{
A list of class \code{intsurv-iCoxph.start} containing all specified
    starting values of the parameters to be estimated from the model.
}
\description{
Auxiliary function for \code{\link{iCoxph}} that enable users
to specify the starting values of the model estimation procedure.
}
\examples{
## See examples of function 'iCoxph'.

}
\seealso{
\code{\link{iCoxph}} for fitting integrative Cox model.
}
