% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intgrd-class.R
\docType{methods}
\name{plot,intgrd,missing-method}
\alias{plot,intgrd,missing-method}
\title{Create an interval plot for spatial grid.}
\usage{
\S4method{plot}{intgrd,missing}(x, beside = TRUE, circleCol = "black",
  minRad = 0.25, ...)
}
\arguments{
\item{x}{An object of class \code{intgrd}.}

\item{beside}{Tf true, center and radius plotted side by side
if false, center and radius are plotted in a single figure with the center
plotted using color and the radius plotted using circles circumscribed
within each grid cell.}

\item{circleCol}{If beside=TRUE, the color of the circles
that will be circumscribed within each grid cell.}

\item{minRad}{The minimum value of the radius in the circles
drawn to represent the interval radii. Must be a number between 0 and 1
where approaching 0 results in a point being drawn in the center of the grid,
while approaching 1 results in every circle being circumscribed in their
respective grid cell (which is not very interesting).}

\item{...}{Additional arguments to \code{\link[sp]{spplot}}.}
}
\description{
Calls \code{\link[sp]{spplot}} to plot the locations, centers, and
radii of an \code{intgrd} object in a single figure.
}
