% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbook_design.R
\name{fieldbook_design}
\alias{fieldbook_design}
\title{Field book experimental designs}
\usage{
fieldbook_design(
  data,
  n_factors = 1,
  type = "crd",
  rep = 2,
  serie = 2,
  seed = 0
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and level. See
examples.}

\item{n_factors}{Number of factor in the experiment(default = 1). See
details.}

\item{type}{Type of experimental arrange  (default = "crd"). See details.}

\item{rep}{Number of replications in the experiment (default = 3).}

\item{serie}{Digits in the plot id (default = 2).}

\item{seed}{Replicability of draw results (default = 0) always random. See
details.}
}
\value{
A list with the fieldbook design
}
\description{
Function to deploy experimental designs based in agricolae package
}
\details{
The function allows to include the arguments in the sheet that have
  the information of the design. You should include 2 columns in the sheet:
  \code{{arguments}} and \code{{values}}. See examples. The information will
  be extracted automatically and deploy the design. \code{n_factors} = 1:
  crd, rcbd, lsd, lattice. \code{n_factors} = 2 (factorial): split_crd,
  split_rcbd \code{n_factors} >= 2 (factorial): crd, rcbd, lsd.
}
\examples{

library(inti)
library(googlesheets4)
library(dplyr)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
, "1ilw0NHT7mihaM-3U48KzkuMt927xe8ukX6rNuIw2fT0/edit#gid=0")
# browseURL(url)
gs <- as_sheets_id(url)

(data <- gs \%>\%
    range_read("tarpuy"))

data \%>\% inti::fieldbook_design(n_factors = 6)

}

}
