% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{PlotHeatmap.intensitynet}
\alias{PlotHeatmap.intensitynet}
\title{Plot the network and if specified, the correlation heatmap. Which could be:}
\usage{
\method{PlotHeatmap}{intensitynet}(
  obj,
  heattype = "none",
  intensity_type = "none",
  net_vertices = NULL,
  ...
)
}
\arguments{
\item{obj}{intensitynet object}

\item{heattype}{'moran': Local Moran-i correlation (with 999 permutations), 'geary': Local Geary-c* 
correlation. The correlations will use the indicated intensity type.
The function also allow to only plot the intensity heatmap 'v_intensity' for vertices or 'e_intensity' for edges.}

\item{intensity_type}{name of the intensity used to plot the heatmap. For undirected networks: 'intensity'. 
For directed networks: 'intensity_in' or 'intensity_out'. For mixed networks: 'intensity_in', 'intensity_out', 
'intensity_und' or 'intensity_all'. If the intensity parameter is NULL, the function will use, if exist, 
the intensity (undirected) or intensity_in (directed) values from the network nodes.}

\item{net_vertices}{chosen vertices to plot the heatmap (or it related edges in case to plot the edge heatmap)}

\item{...}{extra arguments for the class ggplot}
}
\value{
The plot of the heatmap with class c("gg", "ggplot")
}
\description{
Plot the network and if specified, the correlation heatmap. Which could be:
}
\examples{

\dontrun{
data("und_intnet_chicago")
PlotHeatmap(und_intnet_chicago, heattype='moran')
}

}
