% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_tables.R
\name{user_summary}
\alias{user_summary}
\title{User summaries for Super Jetroid}
\usage{
user_summary(
  size = c("small", "medium", "large", "xlarge", "preview"),
  quality = c("perfect", "faulty"),
  type = c("tibble", "data.frame", "duckdb", "csv"),
  keep = FALSE
)
}
\arguments{
\item{size}{A keyword that allows getting different variants of the table
based on the size of player base. The default \code{"small"} table has the
lowest number of players/records. Increasing in size, we can also opt for
the \code{"medium"}, \code{"large"}, or \code{"xlarge"} versions.}

\item{quality}{The data quality level of the returned dataset. There are two
options: (1) \code{"perfect"} provides a pristine table with no errors at all
and (2) \code{"faulty"} gives you a table with a multitude of errors.}

\item{type}{The table return type. By default, this is a \code{"tibble"} but a
\code{"data.frame"} can instead be returned if using that keyword. If you have
the \strong{duckdb} package installed, you can instead obtain the table as an
in-memory DuckDB database table.}

\item{keep}{Should the downloaded data be stored on disk in the working
directory? By default, this is \code{FALSE}. If the file is available in the
next invocation then the data won't be downloaded again.}
}
\value{
A data table object, which could be a tibble (\code{tbl_df}) a data
frame, or an in-memory DuckDB table (\code{tbl_dbi}). If a CSV is written then
\code{TRUE} will be invisibly returned.
}
\description{
This summary table provides information on each user. We get
information here such as the first login/session time and some information
useful for segmentation.
}
\examples{

# Get a preview of the `user_summary` dataset
# with the 'preview' size option
user_summary(size = "preview")

}
