% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_tables.R
\name{all_sessions}
\alias{all_sessions}
\title{All player sessions for Super Jetroid}
\usage{
all_sessions(
  size = c("small", "medium", "large", "xlarge", "preview"),
  quality = c("perfect", "faulty"),
  type = c("tibble", "data.frame", "duckdb", "csv"),
  keep = FALSE
)
}
\arguments{
\item{size}{A keyword that allows getting different variants of the table
based on the size of player base. The default \code{"small"} table has the
lowest number of players/records. Increasing in size, we can also opt for
the \code{"medium"}, \code{"large"}, or \code{"xlarge"} versions.}

\item{quality}{The data quality level of the returned dataset. There are two
options: (1) \code{"perfect"} provides a pristine table with no errors at all
and (2) \code{"faulty"} gives you a table with a multitude of errors.}

\item{type}{The table return type. By default, this is a \code{"tibble"} but a
\code{"data.frame"} can instead be returned if using that keyword. If you have
the \strong{duckdb} package installed, you can instead obtain the table as an
in-memory DuckDB database table.}

\item{keep}{Should the downloaded data be stored on disk in the working
directory? By default, this is \code{FALSE}. If the file is available in the
next invocation then the data won't be downloaded again.}
}
\value{
A data table object, which could be a tibble (\code{tbl_df}) a data
frame, or an in-memory DuckDB table (\code{tbl_dbi}). If a CSV is written then
\code{TRUE} will be invisibly returned.
}
\description{
This table provides information on player sessions and summarizes the number
of revenue events (ad views and IAP spends) and provides total revenue
amounts (in USD) broken down by type for the session.
}
\examples{

# Get a preview of the `all_sessions` dataset
# with the 'preview' size option
all_sessions(size = "preview")

}
