% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obsDAG.R
\name{obsDAG}
\alias{obsDAG}
\title{A DAG function for observational data}
\usage{
obsDAG(X, lambda, tau, rho = 1, A_NZ0 = NULL, A0 = NULL,
  opts.tol = 1e-04, maxIter = 1000)
}
\arguments{
\item{X}{The n by p data matrix}

\item{lambda}{tuning parameter for the first penalty of the adjacency matrix}

\item{tau}{tuning parameter of the TLP function}

\item{rho}{the ADMM penalty parameter, default is 1}

\item{A_NZ0}{An p by p matrix indicating nonzero elements as initial values}

\item{A0}{An p by p matrix as initial values for A}

\item{opts.tol}{Tolerance for convergence}

\item{maxIter}{maximum number of iterations in ADMM loop}
}
\value{
Estimated adjacency matrix
}
\description{
This function allows you to learn the DAG structure from observational data
}
\examples{
p <- 10
amat <- matrix(0, p, p)
amat[2:p, 1] <- 1
Sig <- seq(1, 0.5, length.out=p)
X <- rmvDAG_obs(100, amat, Sig)
out <- obsDAG(X, 5, 0.01)
}
