% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_model.R
\name{species_model}
\alias{species_model}
\title{\emph{species_model}: function to construct an integrated species distribution model, as well as other useful outputs from the model.}
\usage{
species_model(
  speciesNames,
  date = NULL,
  structuredData = NULL,
  spatialCovariates = NULL,
  worldclimCovariates = NULL,
  res = 0.5,
  scale = FALSE,
  location = "Norway",
  boundary = NULL,
  return = "predictions map",
  mesh = NULL,
  meshParameters = NULL,
  spdeModel = NULL,
  projection = CRS("+proj=utm +zone=32 +ellps=WGS84 +datum=WGS84 +units=m +no_defs"),
  limit = 10000,
  options = list(),
  ...
)
}
\arguments{
\item{speciesNames}{A vector of species' names to collect from GBIF.}

\item{date}{Vector of length two denoting the date range to select species from. Defaults to \code{NULL}.}

\item{structuredData}{Additional datasets to integrate with the presence only GBIF data. See the \code{structured_data} function. Defaults to \code{NULL}.}

\item{spatialCovariates}{Spatial covariates to include in the model. May be a \code{Raster} or \code{Spatial} object. Cannot be non-\code{NULL} if \code{worldclimCovariates} is non-\code{NULL}.}

\item{worldclimCovariates}{Names of the covariates to extract from Worldclim. Defaults to \code{NULL}; cannot be non-\code{NULL} if \code{spatialCovariates} is non-\code{NULL}.}

\item{res}{Resolution for the world clim covariates. Valid values are: \code{0.5,2.5,5,10}. Defaults to \code{0.5}.}

\item{scale}{Should the spatial covariates be scaled. Defaults to \code{FALSE}.}

\item{location}{Which area of Norway to model. Defaults to \code{'Norway'} which suggests a model for the entire county.}

\item{boundary}{SpatialPolygons object of the study area. If \code{NULL} an object may be formed with \code{location}.}

\item{return}{Object to return. Has to be one of \code{c('boundary', 'species', 'species plot', 'mesh', 'mesh plot', 'model', 'predictions', 'predictions map')}.}

\item{mesh}{An inla.mesh object to include in the model. Defaults to \code{NULL}.}

\item{meshParameters}{A list of inla.mesh arguments to create a mesh if \code{mesh = NULL}.}

\item{spdeModel}{inla.spde model used in the model. May be a named list where the name of the spde object is the name of the associated dataset. Default NULL uses inla.spde2.matern.}

\item{projection}{CRS projection to use. Defaults to \code{CRS('+proj=utm +zone=32 +ellps=WGS84 +datum=WGS84 +units=m +no_defs')}.}

\item{limit}{Set the number of species downloaded. Defaults to \code{10000}.}

\item{options}{A list of \code{INLA} and \code{inlabru} options. Defaults to \code{NULL}.}

\item{...}{Additional arguments used in PointedSDMs's intModel function.}
}
\value{
The return of the function is determined by the argument \code{return}. For the different values of return: \item{\code{boundary}}{A \code{SpatialPolygon} of the boundary used in the model,} \item{\code{species}}{A \code{data.frame} object of the species' coordinates used in the model,} \item{\code{species plot}}{a \code{ggplot} plot of the species across a map,} \item{\code{mesh}}{an \code{inla.mesh} object,} \item{\code{mesh plot}}{a plot of the \code{inla.mesh object},} \item{model}{the integrated model,} \item{\code{predictions}}{predictions from the integrated model (on the linear scale),} \item{\code{predictions map}}{A \code{ggplot} plot of the predictions across the boundary.}
}
\description{
This function is used to construct integrated species distribution models using data specified with \code{\link{structured_data}} as well as present only data obtained from the Global Biodiversity Information Facility (GBIF).
}
\examples{
{


\dontrun{
 if(requireNamespace('INLA')) {

 #Objects required for example
 data("PA_redlist")
 speciesNames <- c('Fraxinus excelsior', 'Ulmus glabra')

 #Set up structured dataset
   dataObj <- structured_data(PA_redlist, datasetType = c('PA'), responsePA = 'individualCount',
   speciesName = 'species',
   coordinateNames = c("longitude", "latitude" ))

  #Get species map
    predictions <- species_model(return = 'species plot',
    boundary = boundary, speciesNames = species,
    limit = 10, structuredData = dataObj,
    meshParameters = list(cutoff=0.08, max.edge=c(1, 3), offset=c(1,1)),
    worldclimCovariates ='Annual Mean Temperature')
  }

  }

}

}
