% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{summary.reduce}
\alias{summary.reduce}
\title{Automatically create a summary for objects obtained from reduce()}
\usage{
\method{summary}{reduce}(object, period = "days", ...)
}
\arguments{
\item{object}{reduce object produced by \code{reduce()}}

\item{period}{a character string indicating the period to aggregate on. Four options are available: "quarters", "months", "weeks", and "days" (the default option)}

\item{...}{names of columns to aggregate counts by}
}
\value{
data.frame
}
\description{
Takes an object produced by \code{reduce()}, and counts new and lost customers.
}
\examples{
portfolio <- structure(list(policy_nr = c("12345", "12345", "12345", "12345",
"12345", "12345", "12345", "12345", "12345", "12345", "12345"),
productgroup = c("fire", "fire", "fire", "fire", "fire", "fire",
"fire", "fire", "fire", "fire", "fire"), product = c("contents",
"contents", "contents", "contents", "contents", "contents", "contents",
"contents", "contents", "contents", "contents"), begin_dat = structure(c(16709,
16740, 16801, 17410, 17440, 17805, 17897, 17956, 17987, 18017,
18262), class = "Date"), end_dat = structure(c(16739, 16800,
16831, 17439, 17531, 17896, 17955, 17986, 18016, 18261, 18292),
class = "Date"), premium = c(89L, 58L, 83L, 73L, 69L, 94L,
91L, 97L, 57L, 65L, 55L)), row.names = c(NA, -11L), class = "data.frame")

pt1 <- reduce(portfolio, begin = begin_dat, end = end_dat, policy_nr,
    productgroup, product, min.gapwidth = 5)
summary(pt1, period = "days", policy_nr, productgroup, product)

pt2 <- reduce(portfolio, begin = begin_dat, end = end_dat, policy_nr,
    productgroup, product, agg_cols = list(premium), min.gapwidth = 5)
summary(pt2, period = "weeks", policy_nr, productgroup, product)

}
