% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{autoplot.univariate}
\alias{autoplot.univariate}
\title{Automatically create a ggplot for objects obtained from univariate()}
\usage{
\method{autoplot}{univariate}(
  object,
  show_plots = 1:9,
  ncol = 1,
  background = TRUE,
  labels = TRUE,
  sort = FALSE,
  sort_manual = NULL,
  dec.mark = ",",
  color = "dodgerblue",
  color_bg = "#E7B800",
  label_width = 10,
  coord_flip = FALSE,
  ...
)
}
\arguments{
\item{object}{univariate object produced by \code{univariate()}}

\item{show_plots}{numeric vector of plots to be shown (default is c(1,2,3,4,5,6,7,8,9)), there are nine available plots:
 \itemize{
  \item{1. frequency (i.e. number of claims / exposure)}
  \item{2. average severity (i.e. severity / number of claims)}
  \item{3. risk premium (i.e. severity / exposure)}
  \item{4. loss ratio (i.e. severity / premium)}
  \item{5. average premium (i.e. premium / exposure)}
  \item{6. exposure}
  \item{7. severity}
  \item{8. nclaims}
  \item{9. premium}
}}

\item{ncol}{number of columns in output (default is 1)}

\item{background}{show exposure as a background histogram (default is TRUE)}

\item{labels}{show labels with the exposure (default is TRUE)}

\item{sort}{sort (or order) risk factor into descending order by exposure (default is FALSE)}

\item{sort_manual}{sort (or order) risk factor into own ordering; should be a character vector (default is NULL)}

\item{dec.mark}{control the format of the decimal point, as well as the mark between intervals before the decimal point, choose either "," (default) or "."}

\item{color}{change the color of the points and line ("dodgerblue" is default)}

\item{color_bg}{change the color of the histogram ("#E7B800" is default)}

\item{label_width}{width of labels on the x-axis (10 is default)}

\item{coord_flip}{flip cartesian coordinates so that horizontal becomes vertical, and vertical, horizontal (default is FALSE)}

\item{...}{other plotting parameters to affect the plot}
}
\value{
a ggplot2 object
}
\description{
Takes an object produced by \code{univariate()}, and plots the available input.
}
\examples{
library(ggplot2)
x <- univariate(MTPL2, x = area, severity = amount, nclaims = nclaims, exposure = exposure)
autoplot(x)
autoplot(x, show_plots = c(6,1), background = FALSE, sort = TRUE)

MTPL2a <- MTPL2
MTPL2a$jaar <- sample(2015:2019, nrow(MTPL2a), replace = TRUE)
x1 <- univariate(MTPL2a, x = area, severity = amount, nclaims = nclaims,
exposure = exposure, by = jaar)
autoplot(x1, show_plots = 1:2)

}
