% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installRtools.R
\name{install.Rtools}
\alias{install.Rtools}
\alias{install.rtools}
\title{Downloads and installs Rtools}
\usage{
install.Rtools(check = TRUE, check_r_update = TRUE, GUI = TRUE, ...)
}
\arguments{
\item{check}{checks if we need to install Rtools or not.}

\item{check_r_update}{checks if there is an R update available (ignores patch versions),
if so, asks if user wants to install the R update first. (defaults to TRUE)}

\item{GUI}{Should a GUI be used when asking the user questions? (defaults to TRUE)}

\item{...}{extra parameters to pass to \link{install.URL}}
}
\value{
invisible(TRUE/FALSE) - was the installation successful or not.
}
\description{
Install compatible version of Rtools for Windows.
By default, the function searches if a compatible Rtools is installed,
if not, it offers to install the latest compatible version.
}
\details{
Rtools is a collection of software for building packages for R under Microsoft Windows,
or for building R itself (version 1.9.0 or later).
The original collection was put together by Prof. Brian Ripley;
it is currently being maintained by Duncan Murdoch.
}
\examples{
\dontrun{
# installs the latest compatible version of Rtools if a compatible version is not yet installed
install.Rtools()
# (re)installs the latest compatible version of Rtools
install.Rtools(check = F)

# skip R version check
install.Rtools(checkRupdate = F)
}
}
\references{
Rtools homepage: \url{https://cran.r-project.org/bin/windows/Rtools/}
}
