% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_par_.R
\name{inspect_par_bernoulli}
\alias{inspect_par_bernoulli}
\title{Validate parameters for the Bernoulli/Binomial distributions}
\usage{
inspect_par_bernoulli(x)
}
\arguments{
\item{x}{An arbitrary object.}
}
\value{
\code{inspect_par_bernoulli} does not return any output. There are two possible outcomes:
\itemize{
\item The call is silent if \code{x} is an eligible Bernoulli/Binomial proportion.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_par_bernoulli} checks if an object is an eligible Bernoulli/Binomial proportion. This can be useful to validate inputs, intermediate calculations or outputs in user-defined functions.
}
\details{
\code{inspect_par_bernoulli} conducts a series of tests to check if \code{x} is an eligible Bernoulli/Binomial proportion. Namely, \code{inspect_par_bernoulli} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is an atomic vector
\item \code{x} is numeric
\item \code{x} has \code{\link[base]{length}} 1
\item \code{x} is \code{NA} or \code{NaN}.
\item \code{x} is in the (0, 1) interval.
}
}
\examples{
# Calls that pass silently:
x <- 0.5
inspect_par_bernoulli(x)
inspect_par_bernoulli(0.1)

# Calls that throw an informative error message:
mylist <- list(NULL, TRUE, factor(.5), matrix(0.5), "0.5",
  list(0.5), NA, NaN, numeric(0), c(0.1, 0.5), -0.5, 1.1)
try(inspect_par_bernoulli(mylist[[1]]))
try(inspect_par_bernoulli(mylist[[2]]))
try(inspect_par_bernoulli(mylist[[3]]))
try(inspect_par_bernoulli(mylist[[4]]))
try(inspect_par_bernoulli(mylist[[5]]))
try(inspect_par_bernoulli(mylist[[6]]))
try(inspect_par_bernoulli(mylist[[7]]))
try(inspect_par_bernoulli(mylist[[8]]))
try(inspect_par_bernoulli(mylist[[9]]))
try(inspect_par_bernoulli(mylist[[10]]))
try(inspect_par_bernoulli(mylist[[11]]))
try(inspect_par_bernoulli(mylist[[12]]))

}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_par_multinomial}} to validate parameters for the Multinomial distribution.
\item \code{\link[inspector]{inspect_par_beta}} to validate parameters for the Beta distribution.
\item \code{\link[inspector]{inspect_par_dirichlet}} to validate parameters for the Dirichlet distribution.
\item \code{\link[inspector]{inspect_par_haldane}} to validate parameters for the Haldane distribution.
\item \code{\link[inspector]{inspect_data_dichotomous}} to validate dichotomous data.
\item \code{\link[inspector]{inspect_prob}} to check if an object is a numeric vector of valid probability values.
}
}
