% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_varcov.R
\name{get_varcov}
\alias{get_varcov}
\alias{get_varcov.betareg}
\alias{get_varcov.DirichletRegModel}
\alias{get_varcov.clm2}
\alias{get_varcov.truncreg}
\alias{get_varcov.gamlss}
\alias{get_varcov.hurdle}
\alias{get_varcov.zcpglm}
\alias{get_varcov.MixMod}
\alias{get_varcov.glmmTMB}
\alias{get_varcov.brmsfit}
\alias{get_varcov.mixor}
\title{Get variance-covariance matrix from models}
\usage{
get_varcov(x, ...)

\method{get_varcov}{betareg}(x, component = c("conditional", "precision", "all"), ...)

\method{get_varcov}{DirichletRegModel}(x, component = c("conditional", "precision", "all"), ...)

\method{get_varcov}{clm2}(x, component = c("all", "conditional", "scale"), ...)

\method{get_varcov}{truncreg}(x, component = c("conditional", "all"), ...)

\method{get_varcov}{gamlss}(x, component = c("conditional", "all"), ...)

\method{get_varcov}{hurdle}(x, component = c("conditional", "zero_inflated", "zi", "all"), ...)

\method{get_varcov}{zcpglm}(x, component = c("conditional", "zero_inflated", "zi", "all"), ...)

\method{get_varcov}{MixMod}(x, component = c("conditional", "zero_inflated", "zi", "all"), ...)

\method{get_varcov}{glmmTMB}(x, component = c("conditional", "zero_inflated", "zi", "all"), ...)

\method{get_varcov}{brmsfit}(x, component = c("conditional", "zero_inflated", "zi", "all"), ...)

\method{get_varcov}{mixor}(x, effects = c("all", "fixed", "random"), ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Currently not used.}

\item{component}{Should the complete variance-covariance matrix of the model
be returned, or only for specific model components only (like count or
zero-inflated model parts)? Applies to models with zero-inflated component,
or models with precision (e.g. \code{betareg}) component. \code{component}
may be one of \code{"conditional"}, \code{"zi"}, \code{"zero-inflated"},
\code{"precision"}, or \code{"all"}. May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{effects}{Should the complete variance-covariance matrix of the model
be returned, or only for specific model parameters only? Currently only
applies to models of class \code{mixor}.}
}
\value{
The variance-covariance matrix, as \code{matrix}-object.
}
\description{
Returns the variance-covariance, as retrieved by
  \code{stats::vcov()}, but works for more model objects that probably
  don't provide a \code{vcov()}-method.
}
\note{
\code{get_varcov()} tries to return the nearest positive definite matrix
  in case of a negative variance-covariance matrix.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_varcov(m)
}
