% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_remove_backticks.R
\name{text_remove_backticks}
\alias{text_remove_backticks}
\alias{text_remove_backticks.data.frame}
\title{Remove backticks from a string}
\usage{
text_remove_backticks(x, ...)

\method{text_remove_backticks}{data.frame}(x, column = "Parameter", verbose = FALSE, ...)
}
\arguments{
\item{x}{A character vector, a data frame or a matrix. If a matrix,
backticks are removed from the column and row names, not from values
of a character vector.}

\item{...}{Currently not used.}

\item{column}{If \code{x} is a data frame, specify the column of character
vectors, where backticks should be removed. If \code{NULL}, all character
vectors are processed.}

\item{verbose}{Toggle warnings.}
}
\value{
\code{x}, where all backticks are removed.
}
\description{
This function removes backticks from a string.
}
\note{
If \code{x} is a character vector or data frame, backticks are removed from
the elements of that character vector (or character vectors from the data
frame.) If \code{x} is a matrix, the behaviour slightly differs: in this case,
backticks are removed from the column and row names. The reason for this
behaviour is that this function mainly serves formatting coefficient names.
For \code{vcov()} (a matrix), row and column names equal the coefficient names
and therefore are manipulated then.
}
\examples{
# example model
data(iris)
iris$`a m` <- iris$Species
iris$`Sepal Width` <- iris$Sepal.Width
model <- lm(`Sepal Width` ~ Petal.Length + `a m`, data = iris)

# remove backticks from string
names(coef(model))
text_remove_backticks(names(coef(model)))

# remove backticks from character variable in a data frame
# column defaults to "Parameter".
d <- data.frame(Parameter = names(coef(model)),
                Estimate = unname(coef(model)))
d
text_remove_backticks(d)
}
