% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_if_installed.R
\name{check_if_installed}
\alias{check_if_installed}
\title{Checking if needed package is installed}
\usage{
check_if_installed(
  package,
  reason = "for this function to work",
  stop = TRUE,
  minimum_version = NULL,
  ...
)
}
\arguments{
\item{package}{A string (vector) naming the package, whose installation needs
to be checked in any of the libraries.}

\item{reason}{A phrase describing why the package is needed. The default is a
generic description.}

\item{stop}{Logical that decides whether the function should stop if the
needed package is not installed.}

\item{minimum_version}{String, representing the minimum package version that
is required. If \code{NULL}, no check for minimum version is done. Note
that \code{minimum_version} only works when \code{package} is of length 1.}

\item{...}{Currently ignored}
}
\value{
If \code{stop = TRUE}, and \code{package} is not yet installed, the
  function stops and throws an error. Else, a named logical vector is
  returned, indicating which of the packages are installed, and which not.
}
\description{
Checking if needed package is installed
}
\examples{
\dontrun{
check_if_installed("inexistent_package")
check_if_installed("insight")
check_if_installed("insight", minimum_version = "99.8.7")

x <- check_if_installed(c("inexistent", "also_not_here"), stop = FALSE)
x
}
}
