% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_model.R
\name{is_model}
\alias{is_model}
\alias{is_regression_model}
\title{Checks if an object is a regression model or statistical test object}
\usage{
is_model(x)

is_regression_model(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A logical, \code{TRUE} if \code{x} is a (supported) model object.
}
\description{
Small helper that checks if a model is a regression model or
  a statistical object. \code{is_regression_model()} is stricter and only
  returns \code{TRUE} for regression models, but not for, e.g., \code{htest}
  objects.
}
\details{
This function returns \code{TRUE} if \code{x} is a model object.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)

is_model(m)
is_model(mtcars)

test <- t.test(1:10, y = c(7:20))
is_model(test)
is_regression_model(test)
}
