## ----setup,echo=FALSE, include=FALSE------------------------------------------
# setup chunk
NOT_CRAN <- identical(tolower(Sys.getenv("NOT_CRAN")),"true")
knitr::opts_chunk$set(purl = NOT_CRAN)
library(insee)
library(tidyverse)

embed_png <- function(path, dpi = NULL) {
  meta <- attr(png::readPNG(path, native = TRUE, info = TRUE), "info")
  if (!is.null(dpi)) meta$dpi <- rep(dpi, 2)
  knitr::asis_output(paste0(
    "<img src='", path, "'",
    " width=", round(meta$dim[1] / (meta$dpi[1] / 96)),
    " height=", round(meta$dim[2] / (meta$dpi[2] / 96)),
    " />"
  ))}

## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(kableExtra)
library(magrittr)
library(htmltools)
library(prettydoc)

## ---- echo = FALSE------------------------------------------------------------
embed_png("pop.png")

## ----message=FALSE, warning=FALSE,eval=FALSE----------------------------------
#  # please download the Github version
#  # devtools::install_github("hadrilec/insee")
#  library(tidyverse)
#  library(insee)
#  
#  dataset_list = get_dataset_list()
#  
#  df_idbank_list_selected =
#    get_idbank_list("POPULATION-STRUCTURE") %>% #population dataset
#    add_insee_title() %>%
#    filter(INDICATEUR == "POPULATION_1ER_JANVIER") %>% #population at the beginning of the year
#    filter(REF_AREA == "FE") %>%  # all France including overseas departements
#    filter(SEXE == 0) %>%  # men and women
#    filter(AGE %in% c("00-19", "20-59", "60-")) #age ranges
#  
#  list_idbank = df_idbank_list_selected %>% pull(idbank)
#  
#  data = get_insee_idbank(list_idbank)
#  
#  data_plot =
#    data %>%
#    split_title() %>%
#    add_insee_metadata() %>%
#    mutate(OBS_VALUE = OBS_VALUE / 10^6)
#  
#  ggplot(data_plot, aes(x = DATE, y = OBS_VALUE, fill = TITLE_EN3)) +
#    geom_area() +
#    ggtitle("French population in millions, by age") +
#    labs(subtitle = sprintf("Last updated : %s", data_plot$TIME_PERIOD[1]))

