% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon.R
\name{prune_taxon}
\alias{prune_taxon}
\title{Prune taxa from taxonomy database.}
\usage{
prune_taxon(db, taxIDs, keep = TRUE)
}
\arguments{
\item{db}{a copy of the NCBI taxon database, obtained by running
\code{\link{download_taxon}}.}

\item{taxIDs}{the names or taxon ID numbers of the taxa to be retained
(or discarded if \code{keep = FALSE}).}

\item{keep}{logical, indicates whether the specified taxa should be
kept and the rest of the database removed or vice versa. Defaults to TRUE.}
}
\value{
a data.frame with the same column names as
  the input object
  ("tax_id", "parent_tax_id", "rank", "name").
}
\description{
This function prunes the taxon database, removing specified taxa as
  desired to improve speed and memory efficiency.
}
\details{
TBA
}
\examples{
## remove Odontoceti suborder from cetacean taxonomy database
data(whale_taxa)
prune_taxon(whale_taxa, taxIDs = 9722, keep = FALSE)
}
\references{
Federhen S (2012) The NCBI Taxonomy database.
 \emph{Nucleic Acids Research}
 \strong{40}, D136-D143. doi:10.1093/nar/gkr1178.

 \url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\author{
Shaun Wilkinson
}
