% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_content.R
\name{add_content}
\alias{add_content}
\title{Add Content from PDF Documents}
\usage{
add_content(
  pub_id,
  year,
  type = c("text", "image"),
  ...,
  srcdir = "archive",
  destdir = tempdir(),
  ignore = NULL,
  pubs = inlpubs::pubs,
  overwrite = FALSE
)
}
\arguments{
\item{pub_id}{'character' vector.
Unique identifier for the publication.
May also be specified using the \code{year} of publication.}

\item{year}{'integer' vector.
Year of publication.}

\item{type}{'character' string.
Type of content to extract from the PDF file.
Specify as either "text" (the default) or "image".}

\item{...}{Arguments to be passed to the extraction function,
\code{\link{extract_pdf_text}} for "text" and \code{\link{extract_pdf_image}} for "image".}

\item{srcdir}{'character' string.
The PDF document is located in a subdirectory of the source directory,
and this subdirectory is named after the publication year.
It is set to default to the 'archive' directory, which is found in the working directory.}

\item{destdir}{'character' string.
Target folder for the cover image that is saved in JPEG format.
Defaults to the temporary directory.}

\item{ignore}{'character' vector.
Publication identifier(s) to ignore.}

\item{pubs}{'pub' table.
Publications of the INLPO, see \code{\link{pubs}} dataset for data format.}

\item{overwrite}{'logical' flag.
Whether to overwrite an existing text or image file.}
}
\value{
Returns the path to the saved text or image file, invisibly.
}
\description{
Incorporate the text or cover image from a PDF document into the \pkg{inlpubs} package.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
