% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_webpages.R
\name{make_webpages}
\alias{make_webpages}
\title{Create Author and Publication Webpages}
\usage{
make_webpages(authors = NULL, pubs = NULL, destdir = tempdir(), quiet = FALSE)
}
\arguments{
\item{authors}{'author' data frame.
Contributing authors to the INLPO publications, see \code{\link{authors}} dataset for data format.}

\item{pubs}{'pub' data frame.
Publications of the INLPO, see \code{\link{pubs}} dataset for data format.}

\item{destdir}{'character' string.
Destination directory to write files, with tilde-expansion performed.
Defaults to a temporary directory.}

\item{quiet}{'logical' flag.
Whether to suppress printing of debugging information.}
}
\value{
\code{NULL} invisibly.
}
\description{
Creates a webpage for each author, listing their publications.
Each webpage is saved as an \href{https://rmarkdown.rstudio.com/}{R Markdown} file.
}
\examples{
destdir <- tempfile("")
make_webpages(
  authors = inlpubs::authors,
  pubs = inlpubs::pubs,
  destdir = destdir,
  quiet = TRUE
)

unlink(destdir, recursive = TRUE)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
