% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecreateLibrary.R
\name{RecreateLibrary}
\alias{RecreateLibrary}
\alias{SavePackageDetails}
\title{Recreate R Library}
\usage{
RecreateLibrary(file = "R-packages.tsv", lib = .libPaths()[1],
  repos = getOption("repos"), snapshot = FALSE, local = NULL,
  versions = FALSE, parallel = TRUE, quiet = FALSE)

SavePackageDetails(file = "R-packages.tsv", lib = .libPaths(),
  pkg = NULL)
}
\arguments{
\item{file}{'character' string.
Name of the file for reading (or writing) the list of package details.
For a file name that does not contain an absolute path,
the name is assumed relative to the current working directory (see \code{\link{getwd}} function).
A \file{.gz} file extension indicates the file is compressed by \emph{gzip}.}

\item{lib}{'character' vector.
Library tree(s) to search through when locating installed packages (see \code{\link{.libPaths}} function),
or the library directory where to install packages.}

\item{repos}{'character' vector.
Base URL(s) of the CRAN-like repositories (includes CRAN) to use when installing packages.
For example, the URL of the RStudio sponsored CRAN mirror is \code{"https://cloud.r-project.org/"}.
And the URL of the Geological Survey R Archive Network (\href{https://owi.usgs.gov/R/gran.html}{GRAN})
is \code{"https://owi.usgs.gov/R"}.}

\item{snapshot}{'logical' flag, 'Date', or 'character' string.
Calendar date for a CRAN snapshot in time,
see the Microsoft R Application Network
(\href{https://mran.microsoft.com/}{MRAN}) website for details.
If true, the snapshot date is read from the first line of the package-details \code{file}.
A snapshot date can also be specified directly using the required date format, YYYY-MM-DD.
This argument masks any CRAN mirror specified in \code{repos}.}

\item{local}{'character' vector.
Paths to local repositories.
Packages are installed from local files in these directories.
Files can contain \emph{binary} builds of packages (\file{.zip} on Windows and \file{.tgz} on macOS)
or be \emph{source} packages (\file{.tar.gz}).}

\item{versions}{'logical' flag.
If true, installed package versions will be identical to version numbers stored in the package-details \code{file}.
Only applies to packages from CRAN-like repositories and local package-installation files.
Requires that the \pkg{devtools} package is available.}

\item{parallel}{'logical' flag or 'integer' count.
Whether to use parallel processes for a parallel install of more than one source package.
This argument can also be used to specify the number of cores to employ.}

\item{quiet}{'logical' flag.
Whether to reduce the amount of output.}

\item{pkg}{'character' vector.
Names of package(s) located under \code{lib}.
Only packages specified in \code{pkg}, and the packages that \code{pkg} depend on/link to/import/suggest,
will be included in the package-details \code{file}.}
}
\value{
The \code{SavePackageDetails} function returns (invisibly) the MD5 hash of the package-details \code{file} content.
  Any changes in the file content will produce a different MD5 hash.
  Use the \code{\link[tools]{md5sum}} function to verify that a file has not been changed.
  The \code{RecreateLibrary} function returns (invisibly) \code{NULL}.
}
\description{
Recreate an existing library on a new installation of \R.
The \code{SavePackageDetails} function writes the details of installed packages to a text file.
And the \code{RecreateLibrary} function reads this file and downloads and installs any
\sQuote{missing} packages from the Comprehensive R Archive Network (CRAN),
CRAN-like repositories, and local package-installation files.
}
\details{
A typical workflow is as follows:
  Run the \code{SavePackageDetails()} command on an older version of \R.
  It will print to a text file a complete list of details for packages located under your current \R library tree(s).
  If the older version of \R no longer needed, uninstall it.
  Then, on a freshly installed version of \R with the \pkg{inlmisc} package available,
  run the \code{RecreateLibrary()} command.
  It will download and install the packages listed in the package-details \code{file}.

  The type of package to download and install from CRAN-like repositories is
  \emph{binary} on Windows and some macOS builds, and \emph{source} on all others.
  Package installation from a local \file{.tar.gz} file is always a source installation.
  If a package is installed from source, and it contains code that needs compiling,
  you must have a working development environment.
  On Windows, install the \href{https://cran.r-project.org/bin/windows/Rtools/}{Rtools} collection
  and have the PATH environment variable set up as required by Rtools.
  On macOS, install Xcode from the Mac App Store.
  And on Linux, install a compiler and various development libraries.

  Daily snapshots of CRAN are stored on MRAN and available as far back as September 17, 2014.
  Use the \code{snapshot} argument to install older package versions from MRAN.
  Note that newer versions of \R may not be compatible with older versions of packages.
  To avoid any package installation issues,
  install the \R version that was available from CRAN on the
  \href{https://mran.microsoft.com/snapshot/}{snapshot date}.

  The package-details \code{file} is of the following format:
  \preformatted{
# Date modified: YYYY-MM-DD HH:MM:SS UTC
# R version 9.9.9 (YYYY-MM-DD)
Package Version
name    9.9.9
...     ...
  }

  Where the first two lines are reserved for the timestamp and \R-version number, respectively.
  And package data are stored in a tabular structure, that is, data-table values are separated by a TAB character.
  The data format is flexible enough to add additional extraneous metadata and table fields, for example,
  \preformatted{
# Date modified: 2017-08-12 05:14:33 UTC
# R version 3.4.1 (2017-06-30)
# Running under: Windows 10 x64 (build 14393)
# Platform: x86_64-w64-mingw32
Package   Version Priority Depends       Imports
akima     0.6-2   NA       R (>= 2.0.0)  sp
animation 2.5     NA       R (>= 2.14.0) NA
  }
}
\note{
This package-installation method does not offer one-hundred percent reproducibility of existing \R libraries.
  Alternative methods, that offer better reproducibility, are available using the
  \pkg{checkpoint} and \pkg{packrat} packages;
  both of which provide robust tools for dependency management in \R.
}
\examples{
# Run on old version of R
SavePackageDetails()

\dontrun{
# Run on new version of R, and ensure 'inlmisc' package is available.
repos <- c(CRAN = "https://cloud.r-project.org/",
           GRAN = "https://owi.usgs.gov/R")
if (system.file(package = "inlmisc") == "")
  utils::install.packages("inlmisc", repos = repos["CRAN"],
                          dependencies = TRUE)
inlmisc::RecreateLibrary(repos = repos)
}

# Clean up example
file.remove("R-packages.tsv")

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
