% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddScaleBar.R
\name{AddScaleBar}
\alias{AddScaleBar}
\title{Add Scale Bar to Plot}
\usage{
AddScaleBar(unit = NULL, conv.fact = NULL, vert.exag = NULL,
  longlat = FALSE, loc = c("bottomleft", "topleft", "topright",
  "bottomright"), offset = NULL)
}
\arguments{
\item{unit}{'character'.
Vector of length 1 or 2 giving the
label(s) describing the unit of measurement of scale distances, such as "METERS".}

\item{conv.fact}{'numeric'.
Vector of length 1 or 2 giving the
conversion factor(s) for changing the unit of measurement for scale distances.
For example, if user coordinates of the plotting region are in meters,
specify \code{3.28084} to display scale distances in feet.
A dual-unit scale bar is created by specifying a second conversion factor.}

\item{vert.exag}{'logical', 'numeric', or 'character'.
Either a logical value indicating whether to include a vertical exaggeration label;
or a custom \emph{y/x} aspect ratio to include in this label.}

\item{longlat}{'logical'.
Whether user coordinates of the plotting region are in longitude and latitude;
if true, scale distances are in kilometers.
Note that scale distances are calculated at the maps latitude midpoint
using the Great Circle distance (WGS84 ellipsoid) method.}

\item{loc}{'character'.
Position of the scale bar in the plot region specified by keyword:
\code{"bottomleft"}, \code{"topleft"}, \code{"topright"}, or \code{"bottomright"}.}

\item{offset}{'numeric'.
Vector of length 2 indicating the \emph{x} and \emph{y} adjustments
to the position of the scale bar, in inches.}
}
\value{
Used for the side-effect of a scale bar drawn on the current graphics device.
}
\description{
This function can be used to add a scale bar (also known as a rake scale) to a plot.
}
\examples{
plot(-100:100, -100:100, type = "n", xlab = "x in meters", ylab = "y in meters", asp = 2)
AddScaleBar()
AddScaleBar(unit = "METERS", loc = "topleft")
AddScaleBar(unit = c("METERS", "FEET"), conv.fact = c(1, 3.28084), 
            loc = "topright", offset = c(-0.2, 0))
AddScaleBar(unit = c("METERS", "FEET"), conv.fact = c(1, 3.28084), vert.exag = TRUE,
            loc = "bottomright", offset = c(-0.2, 0.2))

plot(c(-38.31, -35.5), c(40.96, 37.5), type = "n", xlab = "longitude", ylab = "latitude")
AddScaleBar(unit = "KILOMETERS", longlat = TRUE)
AddScaleBar(unit = "MILES", conv.fact = 0.621371, longlat = TRUE, loc = "topright")
AddScaleBar(unit = c("KILOMETERS", "MILES"), conv.fact = c(1, 0.621371), 
            longlat = TRUE, loc = "topleft")

}
\seealso{
\code{\link{PlotMap}}, \code{\link{PlotCrossSection}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
