% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddPoints.R
\name{AddPoints}
\alias{AddPoints}
\title{Add Points to Plot}
\usage{
AddPoints(x, y = NULL, z = NULL, zcol = 1, crs = NULL, xlim = NULL,
  ylim = NULL, zlim = NULL, inches = c(0, 0.2),
  scaling = c("perceptual", "mathematical"), bg = "#1F1F1FCB",
  bg.neg = NULL, fg = NA, lwd = 0.25, cex = 0.7, format = NULL,
  legend.loc = "topright", inset = 0.02, breaks = NULL,
  break.labels = NULL, quantile.breaks = FALSE, make.intervals = FALSE,
  title = NULL, subtitle = NULL, add = TRUE, ...)
}
\arguments{
\item{x, y}{numeric or 'SpatialPoints*'.
The x and y coordinates for the centers of the circle symbols.
If numeric, can be specified in any way which is accepted by \code{\link{xy.coords}}.}

\item{z}{'numeric', 'integer', or 'factor'.
Attribute variable.
For objects of class factor, a fixed radius is used for circle symbols,
see \code{inches} argument description.}

\item{zcol}{'integer' or 'character'.
Attribute name or column number to extract from if \code{x} is of class SpatialGridDataFrame.}

\item{crs}{'character' or 'CRS'.
Coordinate reference system arguments}

\item{xlim}{'numeric'.
Vector of length 2 giving the x limits for the plot.}

\item{ylim}{'numeric'.
Vector of length 2 giving the y limits for the plot.}

\item{zlim}{'numeric'.
Vector of length 2 giving the z limits for the plot.}

\item{inches}{'numeric'.
Vector of length 2 giving the radii limits for the drawn circle symbol.
Alternatively, a single number can be given resulting in a fixed radius being used for all circle symbols;
this overrides proportional circles and the function behaves like the \code{\link{points}} function.}

\item{scaling}{'character'.
Selects the proportional symbol mapping algorithm to be used;
either "perceptual" or "mathematical" scaling (Tanimura and others, 2006).}

\item{bg}{'character' or 'function'.
Fill color(s) for circle symbols.
A color palette also may be specified.}

\item{bg.neg}{'character' or 'function'.
Fill color(s) for circle symbols corresponding to negative \code{z} values.
A color palette also may be specified.
For circle symbols corresponding to positive \code{z} values,
the \code{bg} argument is used for color(s).}

\item{fg}{'character'.
Outer-line color for circle symbols.
Specify a value of \code{NA} to remove the symbols outer line, and
\code{NULL} to match the outer-line color with the symbols fill color.}

\item{lwd}{'numeric'.
Line width for drawing circle symbols.}

\item{cex}{'character'.
Character expansion factor for legend labels.}

\item{format}{'character'.
Formatting for legend values, see \code{\link{formatC}} for options.}

\item{legend.loc}{'character'.
Position of the legend in the main plot region:
"bottomleft", "topleft", "topright", or "bottomright" to denote legend location.}

\item{inset}{'numeric'.
Inset distance of the legend from the margins as a fraction of the main plot region.
Defaults to 2 percent of the axis range.}

\item{breaks}{'numeric'.
Set of finite breakpoints for the legend circle symbols.}

\item{break.labels}{'character'.
Vector of break labels with length equal to \code{breaks}.}

\item{quantile.breaks}{'logical'.
If true, \code{breaks} are set to the sample quantiles of \code{z}.}

\item{make.intervals}{'logical'.
If true, represent \code{z} within intervals.
See \code{\link{findInterval}} function for details.
Unused if \code{quantile.breaks} is true.}

\item{title}{'character'.
Main title to be placed at the top of the legend.}

\item{subtitle}{'character'.
Legend subtitle to be placed below the main title.}

\item{add}{'logical'.
If true, circle symbols (and an optional legend) are added to an existing plot.}

\item{...}{Graphics parameters to be passed to \code{\link{PlotMap}}.
Unused if \code{add = TRUE}.}
}
\value{
Used for the side-effect of a bubble map drawn on the current graphics device.
}
\description{
This function can be used to add point symbols to a plot.
Proportional circle symbols may be used to represent point data,
where symbol area varies in proportion to an attribute variable.
}
\note{
To avoid overplotting, circle symbols are drawn in order of decreasing radius.
}
\examples{
set.seed(2)

n <- 50L
x <- cbind(runif(n, 1, 10), runif(n, 1, 500))
z <- runif(n, 0, 1000)
z[sample.int(n, 2)] <- 0
AddPoints(x, z = z, fg = "#00000080", lwd = 0.5, title = "Title",
          subtitle = "Subtitle", add = FALSE)

idxs <- sample.int(n, floor(n / 2))
z[idxs] <- -z[idxs]
AddPoints(x, z = z, bg.neg = "#2A8FBDCB", breaks = pretty(z, n = 8),
          legend.loc = "bottomleft", add = FALSE)

Pal1 <- colorRampPalette(c("#CA0020CB", "#F4A582CB"), alpha = TRUE)
Pal2 <- colorRampPalette(c("#0571B0CB", "#92C5DECB"), alpha = TRUE)
AddPoints(x, z = z, bg = Pal1, bg.neg = Pal2, add = FALSE)

AddPoints(x, z = z, bg = Pal1, bg.neg = Pal2, add = FALSE, make.intervals = TRUE)

AddPoints(x, z = z, bg = Pal1, bg.neg = Pal2, add = FALSE, make.intervals = TRUE,
          inches = 0.1)

AddPoints(x, z = abs(z), title = "Quantiles", bg = topo.colors, quantile.breaks = TRUE,
          add = FALSE)

z <- as.factor(rep(c("dog", "cat", "ant", "pig", "bat"), length.out = n))
AddPoints(x, z = z, bg = rainbow(nlevels(z), end = 0.8, alpha = 0.8), add = FALSE)

AddPoints(x, legend.loc = NULL, add = FALSE)

}
\references{
Tanimura, S., Kuroiwa, C., and Mizota, T., 2006, Proportional Symbol Mapping in R: Journal of Statistical Software, v. 15, no. 5, 7 p.
}
\seealso{
\code{\link{symbols}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
