% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToScientific.R
\name{ToScientific}
\alias{ToScientific}
\title{Format for Scientific Notation}
\usage{
ToScientific(x, digits = format.info(as.numeric(x))[2],
  lab.type = c("latex", "plotmath"))
}
\arguments{
\item{x}{numeric.
Vector of numbers}

\item{digits}{integer.
Number of digits after the decimal point for the mantissa.}

\item{lab.type}{character.
By default, LaTeX formatted strings for labels are returned.
Alternatively, \code{lab.type = "plotmath"} returns plotmath-compatible expressions.}
}
\value{
For the default \code{lab.type = "latex"}, a \code{character} vector of the same length as argument \code{x}.
  And for \code{lab.type = "plotmath"}, an expression of the same length as \code{x},
  typically with elements of the form \code{m x 10^n}.
  In order to comply with \href{https://www.section508.gov}{Section 508},
  an \dQuote{\code{x}} is used as the label separator for the \code{plotmath} type---rather than
  the more common \dQuote{\code{\%*\%}} seperator.
}
\description{
This function formats numbers in scientific notation \eqn{m \times 10^{n}}.
}
\examples{
x <- c(-1e+09, 0, NA, pi * 10^(-5:5))
ToScientific(x, digits = 2)
ToScientific(x, digits = 2, lab.type = "plotmath")

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}

