% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddScaleBar.R
\name{AddScaleBar}
\alias{AddScaleBar}
\title{Add Scale Bar to Plot}
\usage{
AddScaleBar(asp = 1, unit = NULL, is.lonlat = FALSE,
  loc = c("bottomleft", "topleft", "topright", "bottomright"), offset = c(0,
  0), lab.vert.exag = NULL)
}
\arguments{
\item{asp}{numeric.
The \emph{y/x} aspect ratio for spatial axes.}

\item{unit}{character.
Axis unit of measurement, for example "METERS".}

\item{is.lonlat}{logical.
If true, plot coordinates are in longitude and latitude.}

\item{loc}{character. Position of the scale bar in the plot region:
"bottomleft", "topleft", "topright", or "bottomright" to denote scale location.}

\item{offset}{numeric.
The x and y adjustments of the scale bar, in inches.}

\item{lab.vert.exag}{logical.
If true, a label is drawn specifying the vertical exaggeration.}
}
\value{
Used for the side-effect of a scale bar drawn on the current graphics device.
}
\description{
This function can be used to add a scale bar to a plot.
}
\examples{
plot(-100:100, -100:100, type = "n", xlab = "x", ylab = "y", asp = 2)
AddScaleBar(2, unit = "FEET", loc = "topleft")
AddScaleBar(2, unit = "METERS", loc = "bottomright", offset = c(-0.2, 0))

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\seealso{
\code{\link{PlotCrossSection}}, \code{\link{PlotMap}}
}
\keyword{hplot}

