% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_datasets.R
\name{make_datasets}
\alias{make_datasets}
\title{Create Package Datasets}
\usage{
make_datasets(
  path = getwd(),
  destdir = file.path(path, "data"),
  clean = FALSE,
  tz = "America/Denver",
  census_yr = 2023,
  buffer_dist = 1000,
  resolution = 100,
  warn = 1,
  timeout = 10,
  compress = "xz",
  seed = 0L,
  quiet = FALSE
)
}
\arguments{
\item{path}{'character' string.
Path to the package's source directory, with tilde-expansion performed.
Defaults to the working directory.
Ensure that under the \code{path} is a folder named \code{data-raw}
that contains the raw data files required for the build process.}

\item{destdir}{'character' string.
Destination directory to write R-data files, with tilde-expansion performed.
Defaults to the \code{data} directory located under \code{path}.}

\item{clean}{'logical' flag.
Whether to delete all pre-existing R-data files in the destination directory.}

\item{tz}{'character' string.
\link[base:timezones]{Time zone} specification.
Defaults to Mountain Standard Time (North America).
See \code{\link{OlsonNames}} for time zone information.}

\item{census_yr}{'integer' number.
United States census year.}

\item{buffer_dist}{'numeric' number.
Buffer distance for the study area defined by the bounding of the sample \code{\link{sites}} dataset.
Specified in units of the coordinate reference system (\code{crs$units}).}

\item{resolution}{'numeric' number.
Spatial resolution of the raster grid, in meters.
Specify in units of the coordinate reference system (\code{crs$units}).}

\item{warn}{'integer' value.
Sets the handling of warning messages.
Choose value of less than 0 to show no warnings, 1 to print warnings (default),
and 2 to error on warnings.}

\item{timeout}{'integer' number.
Timeout for some of the internet operations, in minutes.
Defaults to 10 minutes.}

\item{compress}{'logical' flag or 'character' string.
Whether compression should be used when saving a dataset to file.
Character strings "auto", "gzip", "bzip2" and "xz" (default) are accepted.
See the \code{\link{save}} function for details on compression types.}

\item{seed}{'integer' count.
Random number generator state, used to create reproducible results.}

\item{quiet}{'logical' flag.
Whether to suppress printing of debugging information.}
}
\value{
Returns the paths to the newly created R Data files invisibly.
}
\description{
Create datasets for the \pkg{inldata} package and save each as an
R-data file with the \code{.rda} extension, which is a format native to \R.
The \pkg{stats} \pkg{dataRetrieval}, and \pkg{stringi} packages must be available.
This function is intended for use by \pkg{inldata}-package developers.
}
\details{
This function retrieves and parses datasets from local and remote sources.
Access to the internet is required to download data from the following remote sources:
\itemize{
\item National Elevation Dataset (\href{https://www.usgs.gov/publications/national-elevation-dataset}{NED})
on \href{https://prd-tnm.s3.amazonaws.com/}{Amazon's Cloud}.
\item Spatial data from the
\href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-geodatabase-file.html}{TIGER/Line Geodatabase}
that contains spatial extracts from the U.S. Census Bureau's
\href{https://www2.census.gov/geo/tiger/TGRGDB22/}{MAF/TIGER database}.
\item National Hydrography Dataset
(\href{https://www.usgs.gov/national-hydrography/national-hydrography-dataset}{NHD})
data from the USGS NHD file geodatabase on \href{https://dmap-data-commons-ow.s3.amazonaws.com/}{Amazon's Cloud}.
}

Each of the package dataset's represents a snapshot of the data at a specified point in time.
While geospatial datasets may change very little over time
(such as the boundary of the Idaho National Laboratory),
other datasets continue to grow as new data becomes available
(such as water-quality data measured in \code{\link{samples}} collected from wells).

To ensure that the function retrieves the most recent data versions,
it is recommended to periodically check the URLs of remote sources and update them within the function.
It is also advisable to document any changes in the datasets and update their help documentation accordingly.

Files downloaded during intermediate stages of the build process
are cached on your computer to speed up future builds.
You can specify the path to the cache directory by setting an environment variable named \code{CACHE_DIR}.
By default the location of the cache directory is determined by the \code{\link[=get_cache_dir]{get_cache_dir()}} command.
}
\examples{
# Example requires that the 'path' argument be specified as
# the top-level directory of the inldata package repository.
\dontrun{
make_datasets(destdir = tempfile(""))
}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
