% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_archive}
\alias{extract_archive}
\title{Extract Archive Contents}
\usage{
extract_archive(file, destdir = tempdir())
}
\arguments{
\item{file}{'character' string.
File path to the archive.}

\item{destdir}{'character' string.
Destination directory to extract files to.
It will be created if necessary.
Defaults to the temporary directory.}
}
\value{
Invisibly returns the extracted path(s).
}
\description{
Extract contents of an archive to a directory.
Requires that the \pkg{archive} package is available.
}
\examples{
files <- system.file("extdata", "test.zip", package = "inldata") |>
  extract_archive()

unlink(files)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
